% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn_plot.R
\name{venn_plot}
\alias{venn_plot}
\title{Venn plot for stat common and unique gene among multiple sets.}
\usage{
venn_plot(
  data,
  title_size = 1,
  label_show = TRUE,
  label_size = 0.8,
  border_show = TRUE,
  line_type = "longdash",
  ellipse_shape = "circle",
  sci_fill_color = "Sci_AAAS",
  sci_fill_alpha = 0.65
)
}
\arguments{
\item{data}{Dataframe: Paired comparisons differentially expressed genes (degs) among groups (1st-col~: degs of paired comparisons).}

\item{title_size}{Numeric: sets title size. Default: 1, min: 0, max: NULL.}

\item{label_show}{Logical: show intersection labels. Default: TRUE, options: TRUE, FALSE.}

\item{label_size}{Numeric: intersection labels size. Default: 0.8, min: 0, max: NULL.}

\item{border_show}{Logical: show border line. Default: TRUE, options: TRUE, FALSE.}

\item{line_type}{Character: ellipse border line type. Default: "blank", options: "blank", "solid", "dashed", "dotted", "dotdash", "longdash", "twodash".}

\item{ellipse_shape}{Character: ellipse shape. Default: "circle", options: "circle", "ellipse".}

\item{sci_fill_color}{Character: ggsci color palette. Default: "Sci_AAAS", options: "Sci_AAAS", "Sci_NPG", "Sci_Simpsons", "Sci_JAMA", "Sci_GSEA", "Sci_Lancet", "Sci_Futurama", "Sci_JCO", "Sci_NEJM", "Sci_IGV", "Sci_UCSC", "Sci_D3", "Sci_Material".}

\item{sci_fill_alpha}{Numeric: ggsci fill color alpha. Default: 0.65, min: 0.00, max: 1.00.}
}
\value{
Plot: venn plot for stat common and unique gene among multiple sets.
}
\description{
Venn plot for stat common and unique gene among multiple sets.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(degs_lists)
head(degs_lists)

# 3. Default parameters
venn_plot(degs_lists)

# 4. Set line_type = "blank"
venn_plot(degs_lists, line_type = "blank")

# 5. Set ellipse_shape = "ellipse"
venn_plot(degs_lists, ellipse_shape = "ellipse")

# 6. Set sci_fill_color = "Sci_IGV"
venn_plot(degs_lists, sci_fill_color = "Sci_IGV")

}
\author{
benben-miao
}
