% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_rpart.R
\name{parse_rpart}
\alias{parse_rpart}
\title{parse_rpart}
\usage{
parse_rpart(tree, include_subgroups = FALSE)
}
\arguments{
\item{tree}{An rpart.object returned from call to rpart().}

\item{include_subgroups}{A logical value indicating whether or not to include
a string representation of the subgroups in the results. Defaults to FALSE.}
}
\value{
A data.frame containing a parsed tree.
}
\description{
Extract splits from an rpart.object returned from a call to
rpart().
}
\details{
This function takes as its input an rpart.object returned from a
call to rpart.  It parses this rpart.object using rpart_nodes() and returns
the splits in the tree. The data returned include the NodeID of the node to
split, the NodeID of that node's parent, the NodeID of that nodes left child
and right child, the number of observations in that node, the variable
used in the split, the data type for the splitting variable, the logic
indicating which observations will go to the node's left child, the
value of the splitting variable at which the split ocurrs, the mean response
value of the node, and (optionally) the string representation of the node's
subgroup. A node's subgroup is defined by the sequence of splits from the
root to that node.
}
\examples{
requireNamespace( "rpart", quietly = TRUE )
## Generate example data containing response, treatment, and covariates
N <- 50
continuous_response = runif( min = 0, max = 20, n = N )
trt <- sample( c('Control','Experimental'), size = N, prob = c(0.4,0.6),
              replace = TRUE )
X1 <- runif( N, min = 0, max = 1 )
X2 <- runif( N, min = 0, max = 1 )
X3 <- sample( c(0,1), size = N, prob = c(0.2,0.8), replace = TRUE )
X4 <- sample( c('A','B','C'), size = N, prob = c(0.6,0.3,0.1), replace = TRUE )

## Fit an rpart model
fit <- rpart::rpart( continuous_response ~ trt + X1 + X2 + X3 + X4,
                     control = rpart::rpart.control( maxdepth = 3L ) )
fit

## Parse the results into a new data.frame
ex1 <- parse_rpart( fit, include_subgroups = TRUE )
ex1
}
\seealso{
\link{rpart_nodes}, \link[rpart]{rpart}, \link[rpart]{rpart.object}
}
