% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SDcheck.R
\name{SDcheck}
\alias{SDcheck}
\title{Performs spell checking using symmetric delete spell correction}
\usage{
SDcheck(keeper, string, summarize = FALSE)
}
\arguments{
\item{keeper}{the structure used in the pre-calculation step to store the 
dictionary symmetrical deletions.}

\item{string}{the misspelled string to correct.}

\item{summarize}{if TRUE returns a list that summarizes the different distances
 of the corrected words. Default is FALSE.}
}
\value{
A vector or a list with the corrected words.
}
\description{
Spell checking for symmetric delete approach. Automatically detects the distance
 with which the keeper was pre-created.
}
\details{
Generate terms with an edit distance <= maxdist (deletes only) from the query
term. As the edit distance between two terms is symmetrical and the deletions
 from the dictionary terms have been pre-stored, the performance is three orders
 of magnitude better than Peter Norvig's approach for distance 2 and five orders
 for distance 3.
}
\examples{
fruitTree <- SDkeeper(c("apple", "orange", "lemon"), 2)
SDcheck(fruitTree,"aple")
SDcheck(fruitTree,"aple", summarize = TRUE)
}
\seealso{
\code{\link{SDkeeper}}
}

