% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GTSplot.R
\name{GTSplot}
\alias{GTSplot}
\title{'GTSplot'}
\usage{
GTSplot(tsdata, NEWtitle = "Result", Ylab = "Value", Xlab = "Time",
  Unit = NULL, ts_name = NULL, title_size = 10, COLO = NULL)
}
\arguments{
\item{tsdata}{A vector or a data frame contains information of time series dataset(i.e. created by \code{ts} function)}

\item{NEWtitle}{title for this plot}

\item{Ylab}{label of Y axis}

\item{Xlab}{label of X axis}

\item{Unit}{the unit of time for the time series data}

\item{ts_name}{a vector contains names for each time line}

\item{title_size}{size of the title}

\item{COLO}{a vector contains colors for each time line}
}
\value{
a plot result created by plot_ly() function
}
\description{
General Plotly method only working on time series data
}
\details{
The function \code{TSplot} is based on package \code{plotly}. It applies \code{plot_ly} function to create
interactive plot for time series data(i.e data generated by function \code{ts}).
}
\examples{
require(forecast)
require(dcemriS4)
require(plotly)

## In the "fMRI" chapter, we have a 4-dimension dataset
## with x,y,z and time dimension (dataset "fMRIVolume").
## So we can settle x,y,and z to determine a vector of time series data.

# You could find the raw "fMRIVolume" dataset on the SOCR website
\donttest{fMRIURL <- "http://socr.umich.edu/HTML5/BrainViewer/data/fMRI_FilteredData_4D.nii.gz"}
\donttest{fMRIFile <- file.path(tempdir(), "fMRI_FilteredData_4D.nii.gz")}
\donttest{download.file(fMRIURL, dest=fMRIFile, quiet=TRUE)}
\donttest{fMRIVolume <- readNIfTI(fMRIFile, reorient=FALSE)}


# Load three time series data(with a wrong format)
\donttest{xA_fMRI_1D_x20_y20_z11 <- fMRIVolume[20, 20, 11, ]}
\donttest{xB_fMRI_1D_x30_y30_z13 <- fMRIVolume[30, 30, 13, ]}
\donttest{xC_fMRI_1D_x40_y40_z12 <- fMRIVolume[40, 40, 12, ]}

# Change this to time series data
TS1<-ts(xA_fMRI_1D_x20_y20_z11,start=0,frequency =1/3)
TS2<-ts(xB_fMRI_1D_x30_y30_z13,start=0,frequency =1/3)
TS3<-ts(xC_fMRI_1D_x40_y40_z12,start=0,frequency =1/3)

# Package them into a data frame
TSDF<-data.frame(TS1,TS2,TS3)

# Using this function to create plot
GTSplot(TSDF,Xlab="Time(second)",Unit="sec",ts_name=c("xA_fMRI_1D_x20_y20_z11",
"xB_fMRI_1D_x30_y30_z13","xC_fMRI_1D_x40_y40_z12"),
              COLO=c("green","red","blue"))
}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
