% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_tools.R
\name{check_res}
\alias{check_res}
\title{Visualization of the Residuals of a Time Series Model}
\usage{
check_res(ts.model, lag.max = 36)
}
\arguments{
\item{ts.model}{A time series model (or forecasted) object, support any model from the forecast package with a residuals output}

\item{lag.max}{The maximum number of lags to display in the residuals' autocorrelation function plot}
}
\description{
Provides a visualization of the residuals of a time series model. 
That includes a time series plot of the residuals, and the plots of the  
autocorrelation function (acf) and histogram of the residuals
}
\examples{
\dontrun{
library(forecast)
data(USgas)

# Create a model
fit <- auto.arima(USgas, lambda = BoxCox.lambda(train))

# Check the residuals of the model
check_res(fit)
}
}
