% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TTR-package.R
\docType{package}
\name{TTR}
\alias{TTR}
\alias{TTR-package}
\title{Functions to create Technical Trading Rules (TTR)}
\description{
This package contains many of the most popular technical analysis functions,
as well as functions to retrieve U.S. stock symbols, and data from Yahoo
Finance.
}
\details{
Users will probably be most interested in the following functions:\cr
\code{\link{ADX}}\cr \code{\link{BBands}}\cr \code{\link{changes}}\cr
\code{\link{MovingAverages}}\cr \code{\link{MACD}}\cr \code{\link{RSI}}\cr
\code{\link{runFun}}\cr \code{\link{stoch}}\cr \code{\link{VWAP}}\cr
\code{\link{WebData}}\cr
}
\examples{
data(ttrc)

# Bollinger Bands
bbands <- BBands( ttrc[,c("High","Low","Close")] )

# Directional Movement Index
adx <- ADX(ttrc[,c("High","Low","Close")])

# Moving Averages
ema <- EMA(ttrc[,"Close"], n=20)
sma <- SMA(ttrc[,"Close"], n=20)

# MACD
macd <- MACD( ttrc[,"Close"] )

# RSI
rsi <- RSI(ttrc[,"Close"])

# Stochastics
stochOsc <- stoch(ttrc[,c("High","Low","Close")])

### Note: you must have a working internet connection
### for the examples below to work!

# Fetch U.S. symbols from the internet
nyseSymbols <- stockSymbols("NYSE")

# Fetch Yahoo! Finance data from the internet
ibm <- getYahooData("IBM", 19990404, 20050607)
}
\author{
Joshua Ulrich

Maintainer: Joshua Ulrich
}
\references{
The following sites were used to code/document this package:\cr
\url{http://www.fmlabs.com/reference/default.htm}\cr
\url{http://www.equis.com/Customer/Resources/TAAZ/?p=0}\cr
\url{http://www.linnsoft.com/tour/technicalindicators.htm}\cr
\url{http://stockcharts.com/education/IndicatorAnalysis/}\cr
}
\keyword{package}

