% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tprDiameter.r
\name{tprDiameter}
\alias{tprDiameter}
\alias{tprDiameter,tprTrees-method}
\title{Functions to extract diameters from Taper curve}
\usage{
tprDiameter(
  obj,
  Hx,
  bark = TRUE,
  interval = "none",
  cp = TRUE,
  mono = TRUE,
  Rfn = NULL
)

\S4method{tprDiameter}{tprTrees}(
  obj,
  Hx,
  bark = TRUE,
  interval = "none",
  cp = TRUE,
  mono = TRUE,
  Rfn = NULL
)
}
\arguments{
\item{obj}{object of class 'tprTrees'}

\item{Hx}{vector of heights for which diameter w/ or w/0 bark are required}

\item{bark}{should diameter over or under bark be returned?}

\item{interval}{indicator about whether 'confidence' or 'prediction'
intervals are required (defaults to 'none'), optionally function returns the
mean squared error of the mean and predictions ('MSE').}

\item{cp}{cartesian product, i.e. apply all \code{Hx} to all trees, defaults
to TRUE}

\item{mono}{logical, defaults to true. If calibrated taper curve is
non-monotonic at stem base, a support diameter is added.}

\item{Rfn}{Rfn setting for residuals error matrix, defaults to
\code{list(fn="sig2")}, see \code{\link[TapeR]{resVar}}.}
}
\value{
a matrix or data.frame depending on value of \code{interval}. If
'none' (the default), a matrix of size [length(obj@Ht), length(Hx)] is
returned, otherwise a data.frame of size [length(obj@Ht) * length(Hx), 5].
The five columns hold a tree identifier, Hx, lower confidence/prediction
interval, the estimated diameter and the upper confidence/prediction
interval. In case 'interval=MSE' the returned columns contain a tree
identifier, Hx, the estimated diameter and mean squared error (MSE) of the
mean and of the prediction. Estimates and intervals include bark or not,
depending on \code{bark}.
}
\description{
Function evaluates TapeR taper curve models for given trees
according to species, required height and optionally substracts double bark
thickness.
}
\details{
Function evaluates taper curves at required height \code{Hx}. By
default (\code{cp==TRUE}), the taper curve is evaluated at \code{Hx} for each
tree. If \code{cp==FALSE}, each tree is evaluated at exactly one Hx (recycled
if necessary). This feature is intended for situations where diameter in
relative heights are required. Then, the recycling of one height Hx (e.g.
1.3m) is not possible, since relative heights depend on absolute tree height,
which might be different for each tree. Hence a call like
\code{tprDiameter(obj, Hx=0.3*Ht(obj), cp=FALSE)} is necessary.
}
\section{Methods (by class)}{
\itemize{
\item \code{tprDiameter(tprTrees)}: method for class 'tprTrees'

}}
\examples{
## prediction for new tree using implemented 'TapeR' taper curve model
obj <- tprTrees(spp=c(1, 3),
                Hm=list(c(1.3, 5), c(1.3, 5)),
                Dm=list(c(27, 25), c(27, 25)),
                Ht=c(27, 27))
hx <- c(1.3, 5, 7)
## by default, Hx applied on each tree, i.e. result is a 2x3 matrix
tprDiameter(obj, Hx = hx)

## if cp=FALSE, each tree only 'sees' one Hx, i.e. results is a vector
## (obs: length of Hx must be identical to length of obj)
tprDiameter(obj, Hx = c(1.3, 5), cp=FALSE)
tprDiameter(obj, Hx = hx, bark = FALSE)
tprDiameter(obj, Hx = hx, interval = "confidence")
tprDiameter(obj, Hx = hx, bark = FALSE, interval = "prediction")
tprDiameter(obj, Hx = hx, interval = "MSE")
tprDiameter(obj, Hx = hx, bark=FALSE, interval = "MSE")

## here same behaviour, if cp=FALSE
tprDiameter(obj, Hx = c(1.3, 5), bark = FALSE,
            interval = "prediction", cp=FALSE)
## using Cpp-implementation
## faster, but no intervals available
tprDiameterCpp(obj, Hx = hx)
tprDiameterCpp(obj, Hx = c(1.3, 5), cp=FALSE)

## prediction for objects of class 'datBDAT':
if(require(rBDAT)){
  tree <- rBDAT::buildTree(list(spp=1, D1=20:30, H1=1.3, H2=50, H=20:30))
  tree <- bdat_as_tprtrees(tree)
  tprDiameter(tree, Hx = 1.3)
}
}
\seealso{
\code{\link{tprDiameterCpp}} for a faster implementation if no
confidence or prediction information are required and \code{\link{tprBark}}
for the applied bark reduction.
}
