% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_xrefs.R
\name{check_xrefs}
\alias{check_xrefs}
\title{Check cross-references}
\usage{
check_xrefs(filename, permitted.case = c(NA, "upper", "lower"),
  .report_error)
}
\arguments{
\item{filename}{A LaTeX file}

\item{permitted.case}{One of \code{NA, "upper", "lower"}. If \code{NA}, the default,
both \verb{\Cref} and \verb{\cref} are permitted, but not in the same document.
If \code{upper}, only \verb{\Cref} 
is permitted; if \code{lower}, only \verb{\cref}.
If \code{NULL}, the case is not checked at all.}

\item{.report_error}{The function to provide context to the error.}
}
\description{
Check cross-references that are repetitive or (in the case of \verb{cleveref} and \verb{varioref}) incorrect case.
}
