% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{charTSS}
\alias{charTSS}
\title{Characteristic function of the tempered stable subordinator}
\usage{
charTSS(t, alpha = NULL, delta = NULL, lambda = NULL, theta = NULL)
}
\arguments{
\item{t}{A vector of real numbers where the CF is evaluated.}

\item{alpha}{Stability parameter. A real number between 0 and 1.}

\item{delta}{Scale parameter. A real number > 0.}

\item{lambda}{Tempering parameter. A real number > 0.}

\item{theta}{Parameters stacked as a vector.}
}
\value{
The CF of the tempered stable subordinator distribution.
}
\description{
Theoretical characteristic function (CF) of the distribution of the tempered
stable subordinator. See Kawai & Masuda (2011) for details.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, delta, lambda)}.
Either provide the parameters \code{alpha}, \code{delta}, \code{lambda}
individually OR provide \code{theta}.
\deqn{\varphi_{TSS}(t;\theta):=E_{\theta}\left[
\mathrm{e}^{\mathrm{i}tY}\right]= \exp\left(\delta\Gamma(-\alpha)
\left((\lambda-\mathrm{i}t)^{\alpha}-\lambda^{\alpha}\right)\right)}
}
\examples{
x <- seq(-10,10,0.25)
y <- charTSS(x,0.5,1,1)

}
\references{
Massing, T. (2023), 'Parametric Estimation of Tempered Stable Laws'

Kawai, R. & Masuda, H. (2011), 'On simulation of tempered stable random
variates' \doi{10.1016/j.cam.2010.12.014}

Kuechler, U. & Tappe, S. (2013), 'Tempered stable distributions and
processes' \doi{10.1016/j.spa.2013.06.012}
}
