% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Contours.R
\name{TernaryPointValues}
\alias{TernaryPointValues}
\alias{TernaryDensity}
\title{Value of a function at regularly spaced points}
\usage{
TernaryPointValues(Func, resolution = 48L,
  direction = getOption("ternDirection"))

TernaryDensity(coordinates, resolution = 48L,
  direction = getOption("ternDirection"))
}
\arguments{
\item{Func}{Function taking the parameters \code{a}, \code{b} and \code{c}, which evaluates to a numeric
whose value should be depicted.}

\item{resolution}{The number of triangles whose base should lie on the longest
axis of the triangle.  Higher numbers will result in smaller subdivisions and smoother
colour gradients, but at a computational cost.}

\item{direction}{(optional) Integer specifying the direction that the current ternary plot
should point: 1, up; 2, right; 3, down; 4, left.}

\item{coordinates}{A list, matrix, data.frame or vector in which each
element (or row) specifies
the three coordinates of a point in ternary space.}
}
\value{
A matrix whose rows correspond to:

\strong{x}, \strong{y}: co-ordinates of the centres of smaller triangles

\strong{z}: The value of \code{Func(a, b, c)}, where \code{a}, \code{b} and \code{c} are the
ternary coordinates of \code{x} and \code{y}.

\strong{down}: \code{0} if the triangle concerned points upwards (or right),
\code{1} otherwise
}
\description{
Evaluates a function at points on a triangular grid.
Intended to facilitate coloured contour plots with \code{\link{ColourTernary}}.
}
\details{
Density plotting functions are somewhat experimental; please
\href{https://github.com/ms609/Ternary/issues/new}{report any issues}.
}
\section{Functions}{
\itemize{
\item \code{TernaryDensity}: Returns the density of points in each triangle
}}

\seealso{
Other contour plotting functions: \code{\link{ColourTernary}},
  \code{\link{TernaryContour}},
  \code{\link{TernaryDensityContour}}
}
\author{
Martin R. Smith
}
\concept{contour plotting functions}
