% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATA_functions.R
\docType{methods}
\name{ATA}
\alias{ATA}
\alias{ATA,config_ATA-method}
\title{Run Automated Test Assembly}
\usage{
ATA(config, constraints, plot = FALSE, plot_range = c(-3, 3))

\S4method{ATA}{config_ATA}(config, constraints, plot = FALSE,
  plot_range = c(-3, 3))
}
\arguments{
\item{config}{An \code{\linkS4class{config_ATA}} object containing configuration options. Use \code{\link{createStaticTestConfig}} for this.}

\item{constraints}{A list representing optimization constraints. Use \code{\link{loadConstraints}} for this.}

\item{plot}{Logical. If \code{TRUE}, draw Fisher information plot from the selected items.}

\item{plot_range}{Numeric. A vector of length 2 containing the lower and upper bounds of plot range. The default is \code{c(-3, 3)}.}
}
\value{
A list containing the following entries:
\itemize{
  \item{\code{MIP}} A list containing the result from MIP solver.
  \itemize{
    \item{\code{solution}} Solution vector. Each value represents an item. A value of 1 indicates the item was selected.
    \item{\code{objval}} Objective value of the solution.
    \item{\code{status}} Status value indicating whether an optimal solution was found.
  }
  \item{\code{selected}} The attributes of the selected items.
  \item{\code{solver}} The name of the MIP solver used in the assembly.
  \item{\code{obj_value}} Objective value of the solution. Identical to the one above.
  \item{\code{solve_time}} The elapsed time in running the solver.
}
}
\description{
Perform Automated Test Assembly with specified configurations.
}
\examples{
config_science <- createStaticTestConfig(
  list(
    method = "MAXINFO",
    target_location = c(-1, 1)
  )
)
solution <- ATA(config_science, constraints_science, plot = TRUE)

}
\references{
\insertRef{van_der_linden_linear_2005}{TestDesign}
}
