% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{loadStAttrib}
\alias{loadStAttrib}
\title{Load set/stimulus/passage attributes}
\usage{
loadStAttrib(file, item_attrib)
}
\arguments{
\item{file}{Character. The name of the file containing stimulus attributes.}

\item{item_attrib}{An \code{\linkS4class{item_attrib}} object containing item attributes. Use \code{\link{loadItemAttrib}} for this.}
}
\value{
A \code{\linkS4class{st_attrib}} object containing stimulus attributes.
}
\description{
Read set, stimulus, or passage attributes from specified file.
}
\examples{
## Write to tempdir() and clean afterwards
f <- file.path(tempdir(), "itempool_reading.csv")
write.csv(itempool_reading_raw, f, row.names = FALSE)
itempool_reading <- loadItemPool(f)
file.remove(f)

f <- file.path(tempdir(), "itemattrib_reading.csv")
write.csv(itemattrib_reading_raw, f, row.names = FALSE)
itemattrib_reading <- loadItemAttrib(f, itempool_reading)
file.remove(f)

f <- file.path(tempdir(), "stimattrib_reading.csv")
write.csv(stimattrib_reading_raw, f, row.names = FALSE)
stimattrib_reading <- loadStAttrib(f, itemattrib_reading)
file.remove(f)

f <- file.path(tempdir(), "constraints_reading.csv")
write.csv(constraints_reading_raw, f, row.names = FALSE)
constraints_reading <- loadConstraints(f,
  itempool_reading, itemattrib_reading, stimattrib_reading)
file.remove(f)

}
\seealso{
\link{dataset_reading} for example usage.
}
