% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{buildConstraints}
\alias{buildConstraints}
\title{Build constraints}
\usage{
buildConstraints(
  pool,
  file_constraints,
  file_item_attrib,
  file_st_attrib = NULL
)
}
\arguments{
\item{pool}{An \code{item_pool} object. Use \code{\link{loadItemPool}} for this.}

\item{file_constraints}{Character. The name of the file containing constraint specifications.}

\item{file_item_attrib}{Character. The name of the file containing item attributes.}

\item{file_st_attrib}{(Optional) Character. The name of the file containing set attributes.}
}
\value{
A list containing the parsed constraints, to be used in \code{\link{Static}} and \code{\link{Shadow}}.
}
\description{
Read constraints from specified files.
}
\examples{
## Write to tempdir() and clean afterwards
f1 <- file.path(tempdir(), "constraints_science.csv")
write.csv(constraints_science_raw, f1, row.names = FALSE)
f2 <- file.path(tempdir(), "itemattrib_science.csv")
write.csv(itemattrib_science_raw, f2, row.names = FALSE)

constraints <- buildConstraints(itempool_science, f1, f2)

file.remove(f1)
file.remove(f2)

}
