% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_data_cache_operators.r
\docType{methods}
\name{makeTest}
\alias{makeTest}
\alias{makeTest,item_pool-method}
\title{Create a test object}
\usage{
makeTest(
  object,
  theta = seq(-4, 4, 0.1),
  info_type = "FISHER",
  true_theta = NULL
)

\S4method{makeTest}{item_pool}(
  object,
  theta = seq(-4, 4, 0.1),
  info_type = "FISHER",
  true_theta = NULL
)
}
\arguments{
\item{object}{an \code{\linkS4class{item_pool}} object.}

\item{theta}{a grid of theta values.}

\item{info_type}{the type of information.}

\item{true_theta}{(optional) true theta values to simulate response data.}
}
\description{
\code{\link{makeTest}} is a function for creating a \code{\linkS4class{test}} object.
This is used to make all necessary data (e.g., item information, response data) prior to the main simulation.
This function is only kept for backwards compatibility.
The functionality of this function is superseded by \code{\link{makeSimulationDataCache}}.
}
\examples{
test <- makeTest(itempool_science, seq(-3, 3, 1))
}
