% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{multivariate}
\alias{multivariate}
\title{Multivariate Analysis Of Sexual Dimorphism}
\usage{
multivariate(x, R.res = NULL, Trait = 1, Pop = 2,
  univariate = FALSE, padjust = "none", lower_tail = FALSE)
}
\arguments{
\item{x}{Data frame or list containing summary statistics of for multiple
parameters measured in both sexes in two or more populations.}

\item{R.res}{Pooled within correlational matrix, Default: \code{NULL}.}

\item{Trait}{Number of the column containing names of measured traits,
Default: \code{1}.}

\item{Pop}{Number of the column containing populations' names, Default:
\code{2}.}

\item{univariate}{Logical; if \code{TRUE} conducts multiple univariate
analyses on different parameters separately, Default: \code{FALSE}.}

\item{padjust}{Method of p value adjustment following
\code{p.adjust.methods}, Default: \code{'none'}}

\item{lower_tail}{Logical; if \code{TRUE}, probabilities are \code{P[X <=
x]}, otherwise, \code{P[X > x]} for multivariate analysis, Default:
\code{FALSE}}
}
\value{
\code{MANOVA} or \code{ANOVA} table(s).
}
\description{
Multivariate extension of Greene t-test \code{\link{Tg}}.
}
\details{
Data can be entered either as a data frame where the first 2 columns
  contain traits to be measured \code{Trait} and the populations' names
  \code{Pop} and other columns containing different summary statistics as in
  \code{\link{baboon.parms_df}}. In that case the pooled within correlational matrix
  \code{R.res} should be entered as an argument. Another acceptable format is
  a list of matrices containing different summary statistics as well as the
  correlational matrix \code{\link{R}} as in \code{\link{baboon.parms_list}}. By
  setting the option \code{univariate} to \code{TRUE}, multiple \code{ANOVA}s
  can be run on each parameter independently with the required p value
  correction \code{padjust}.
}
\examples{

# x is a data frame with seprate correlational matrix
library(TestDimorph)
multivariate(x = baboon.parms_df, R.res = R)
# x is a list with the correlational matrix included
library(TestDimorph)
multivariate(baboon.parms_list, univariate = TRUE, padjust = 'bonferroni')

}
\references{
\insertRef{konigsberg1991historical}{TestDimorph}
}
