% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aov_ss.R
\name{aov_ss}
\alias{aov_ss}
\title{Sex Specific One way ANOVA From Summary statistics}
\usage{
aov_ss(
  x,
  Pop = 1,
  pairwise = TRUE,
  letters = FALSE,
  es = FALSE,
  digits = 4,
  sig.level = 0.05
)
}
\arguments{
\item{x}{A data frame containing summary statistics.}

\item{Pop}{Number of the column containing populations' names, Default: 1}

\item{pairwise}{Logical; if TRUE runs multiple pairwise comparisons on
different populations using Tukey's post hoc test, Default: TRUE}

\item{letters}{Logical; if TRUE returns letters for pairwise comparisons
where significantly different populations are given different letters,
Default: FALSE'}

\item{es}{Logical; if TRUE effect size is included in the output , Default:
FALSE}

\item{digits}{Number of significant digits, Default: 4}

\item{sig.level}{Critical p.value, Default: 0.05}
}
\value{
Sex specific ANOVA tables and pairwise comparisons in tidy format.
}
\description{
Calculates sex specific one way ANOVA from summary statistics.
}
\details{
Data is entered as a tibble/data frame of summary statistics where
the column containing population names is chosen by position (first by
default), other columns of summary data should have specific names (case
sensitive) similar to \link{baboon.parms_df}
}
\examples{
\donttest{
# Comparisons of femur head diameter in four populations
library(TestDimorph)
df <- data.frame(
  Pop = c("Turkish", "Bulgarian", "Greek", "Portuguese "),
  m = c(150.00, 82.00, 36.00, 34.00),
  f = c(150.00, 58.00, 34.00, 24.00),
  M.mu = c(49.39, 48.33, 46.99, 45.20),
  F.mu = c(42.91, 42.89, 42.44, 40.90),
  M.sdev = c(3.01, 2.53, 2.47, 2.00),
  F.sdev = c(2.90, 2.84, 2.26, 2.90)
)
aov_ss(x = df)
}
}
