% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patients.R
\name{readPatients}
\alias{readPatients}
\title{Converts a sample of patients into Unit Testing Definition JSON file.}
\usage{
readPatients(
  filePath = NULL,
  testName = "test",
  outputPath = NULL,
  cdmVersion = "5.3"
)
}
\arguments{
\item{filePath}{Path to the test patient data in Excel format. The Excel has sheets that represent tables from the OMOP-CDM, e.g. person, drug_exposure, condition_ocurrence, etc.}

\item{testName}{A name of the test population in character.}

\item{outputPath}{Path of the output file, if NULL, a folder will be created in the project folder inst/testCases.}

\item{cdmVersion}{cdm version, default "5.3".}
}
\value{
A JSON file with sample patients inside the project directory.
}
\description{
Converts a sample of patients into Unit Testing Definition JSON file.
}
\examples{
filePath <- system.file("extdata", "testPatientsRSV.xlsx", package = "TestGenerator")
readPatients(filePath = filePath, outputPath = tempdir())

}
