% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/taNegBin.OptAllocation.R
\name{taNegBin.OptAllocation}
\alias{taNegBin.OptAllocation}
\title{Optimal sample size for three-armed clinical trials with negative binomial distributed endpoints}
\usage{
taNegBin.OptAllocation(rateExp, rateRef, ratePla, shape, Delta,
  type = c("restricted", "unrestricted"), n = NULL, sig.level = NULL)
}
\arguments{
\item{rateExp}{A numeric value specifying the rate of the experimental treatment group in the alternative hypothesis}

\item{rateRef}{A numeric value specifying the rate of the reference treatment group in the alternative hypothesis}

\item{ratePla}{A numeric value specifying the rate of the placebo treatment group in the alternative hypothesis}

\item{shape}{A numeric value specifying the shape parameter}

\item{Delta}{A numeric value specifying the non-inferiority/superiority margin}

\item{type}{A character string determing how the variance for the Wald-type test statistic is estimated, must be \emph{restricted}, or \emph{unrestricted}}

\item{n}{The total sample size. This parameter is only mandatory for \emph{type='restricted'}. For \emph{type='unrestricted'}, this parameter is optional.}

\item{sig.level}{A numeric value specifying the significance level (type I error probability). This parameter is only mandatory for \emph{type='restricted'}. For \emph{type='unrestricted'}, this parameter is optional.}
}
\value{
A list with class "power.htest" containing the following components:
\item{n}{The total sample size. Not mandatory.}
\item{Delta}{A numeric value specifying the non-inferiority/superiority margin}
\item{type}{A character string indicating what type of Wald-type test will be performed}
\item{allocation}{A vector with the sample size allocation (nExp/n, nRef/n, nPla/n)}
\item{rateExp}{A numeric value specifying the rate of the experimental treatment group in the alternative hypothesis}
\item{rateRef}{A numeric value specifying the rate of the reference treatment group in the alternative hypothesis}
\item{ratePla}{A numeric value specifying the rate of the placebo treatment group in the alternative hypothesis}
\item{shape}{A numeric value specifying the shape parameter}
\item{nExp}{A numeric value specifying the number of sample in the experimental treatment group}
\item{nRef}{A numeric value specifying the number of sample in the reference treatment group}
\item{nPla}{A numeric value specifying the number of sample in the placebo treatment group}
}
\description{
Calculate optimal sample size allocation for Wald-type test for superiority or non-inferiority of the experimental treatment versus reference treatment with respect to placebo
}
\examples{
# Example for type = 'unrestricted'
taNegBin.OptAllocation(rateExp = 2, rateRef = 2, ratePla = 4, shape = 0.5, Delta = 0.8,
 type = 'unrestricted', n = 1048, sig.level = 0.025)
taNegBin.OptAllocation(rateExp = 2, rateRef = 2, ratePla = 4, shape = 0.5, Delta = 0.8,
 type = 'unrestricted')

# Example for type = 'restricted'.
\dontrun{
taNegBin.OptAllocation(rateExp = 2, rateRef = 2, ratePla = 4, shape = 0.5, Delta = 0.8,
 type = 'restricted', n = 500, sig.level = 0.025)
}
}
\keyword{NegativeBinomial}
\keyword{optimalSampleSizeAllocation}

