% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_bindings.R
\name{add_total_row}
\alias{add_total_row}
\title{Add a Total row into a count summary.}
\usage{
add_total_row(e, fmt = NULL, count_missings = TRUE, sort_value = NULL)
}
\arguments{
\item{e}{A \code{count_layer} object}

\item{fmt}{An f_str object used to format the total row. If none is provided,
display is based on the layer formatting.}

\item{count_missings}{Whether or not to ignore the named arguments passed in
`set_count_missing()` when calculating counts total row. This is useful if
you need to exclude/include the missing counts in your total row. Defaults
to TRUE meaning total row will not ignore any values.}

\item{sort_value}{The value that will appear in the ordering column for total
rows. This must be a numeric value.}
}
\description{
Adding a total row creates an additional observation in the count summary
that presents the total counts (i.e. the n's that are summarized). The format
of the total row will be formatted in the same way as the other count
strings.
}
\details{
Totals are calculated using all grouping variables, including treat_var and
cols from the table level. If by variables are included, the grouping of the
total and the application of denominators becomes ambiguous. You will be
warned specifically if a percent is included in the format. To rectify this,
use \code{set_denoms_by()}, and the grouping of \code{add_total_row()} will
be updated accordingly.
}
\examples{
# Load in Pipe
library(magrittr)

tplyr_table(mtcars, gear) \%>\%
  add_layer(
    group_count(cyl) \%>\%
      add_total_row(f_str("xxxx", n))
   ) \%>\%
   build()
}
