% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_bindings.R
\name{keep_levels}
\alias{keep_levels}
\title{Select levels to keep in a count layer}
\usage{
keep_levels(e, ...)
}
\arguments{
\item{e}{A \code{count_layer} object}

\item{...}{Character values to count int he layer}
}
\value{
The modified Tplyr layer object
}
\description{
In certain cases you only want a layer to include certain values of a factor.
The `keep_levels()` function allows you to pass character values to be
included in the layer. The others are ignored.
**NOTE: Denominator calculation is unaffected by this function, see the
examples on how to include this logic in your percentages'**
}
\examples{
library(dplyr)
mtcars <- mtcars \%>\%
  mutate_all(as.character)

t <- tplyr_table(mtcars, gear) \%>\%
  add_layer(
    group_count(cyl) \%>\%
      keep_levels("4", "8") \%>\%
      set_denom_where(cyl \%in\% c("4", "8"))
 ) \%>\%
 build()

}
