% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuroLotteryBacktesting.R
\name{EuroLotteryBacktesting}
\alias{EuroLotteryBacktesting}
\title{Euromillions/EuroJackpot Backtesting}
\usage{
EuroLotteryBacktesting(euroLottery_results, date_since, user_input)
}
\arguments{
\item{euroLottery_results}{The full list of EuroMillions/EuroJackpot results}

\item{date_since}{The date after which the analysis is to be performed, i.e. 2022-12-22}

\item{user_input}{The seven numbers the user has selected}
}
\value{
The backtested results
}
\description{
Backtests the numbers the user has selected against the full (or the specified) history of Euromillions/EuroJackpot results
}
\examples{

euromillions_results = EuroMillionsResults()
user_input = c(10,20,30,40,50,5,10)
backtested_results = EuroLotteryBacktesting(euromillions_results, '2005-01-01', user_input)
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
