% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferTTree.R
\name{inferTTree}
\alias{inferTTree}
\title{Infer transmission tree given a phylogenetic tree}
\usage{
inferTTree(ptree, w.shape = 2, w.scale = 1, ws.shape = NA,
  ws.scale = NA, w.mean = NA, w.std = NA, ws.mean = NA,
  ws.std = NA, mcmcIterations = 1000, thinning = 1,
  startNeg = 100/365, startOff.r = 1, startOff.p = 0.5,
  startPi = 0.5, updateNeg = TRUE, updateOff.r = TRUE,
  updateOff.p = FALSE, updatePi = TRUE, startCTree = NA,
  updateTTree = TRUE, optiStart = 2, dateT = Inf, verbose = F)
}
\arguments{
\item{ptree}{Phylogenetic tree}

\item{w.shape}{Shape parameter of the Gamma distribution representing the generation time}

\item{w.scale}{Scale parameter of the Gamma distribution representing the generation time}

\item{ws.shape}{Shape parameter of the Gamma distribution representing the sampling time}

\item{ws.scale}{Scale parameter of the Gamma distribution representing the sampling time}

\item{w.mean}{Mean of the Gamma distribution representing the generation time}

\item{w.std}{Std of the Gamma distribution representing the generation time}

\item{ws.mean}{Mean of the Gamma distribution representing the sampling time}

\item{ws.std}{Std of the Gamma distribution representing the sampling time}

\item{mcmcIterations}{Number of MCMC iterations to run the algorithm for}

\item{thinning}{MCMC thinning interval between two sampled iterations}

\item{startNeg}{Starting value of within-host coalescent parameter Ne*g}

\item{startOff.r}{Starting value of parameter off.r}

\item{startOff.p}{Starting value of parameter off.p}

\item{startPi}{Starting value of sampling proportion pi}

\item{updateNeg}{Whether of not to update the parameter Ne*g}

\item{updateOff.r}{Whether or not to update the parameter off.r}

\item{updateOff.p}{Whether or not to update the parameter off.p}

\item{updatePi}{Whether or not to update the parameter pi}

\item{startCTree}{Optional combined tree to start from}

\item{updateTTree}{Whether or not to update the transmission tree}

\item{optiStart}{Type of optimisation to apply to MCMC start point (0=none, 1=slow, 2=fast)}

\item{dateT}{Date when process stops (this can be Inf for fully simulated outbreaks)}

\item{verbose}{Whether or not to use verbose mode (default is false)}
}
\value{
posterior sample set of transmission trees
}
\description{
Infer transmission tree given a phylogenetic tree
}
\examples{
inferTTree(ptreeFromPhylo(ape::rtree(5),2020),mcmcIterations=100)
}
