% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{MSTSegments}
\alias{MSTSegments}
\alias{StrainCol}
\title{Add minimum spanning tree to plot, colouring by stress}
\usage{
MSTSegments(mapping, mstEnds, ...)

StrainCol(
  distances,
  mapping,
  mstEnds = MSTEdges(distances),
  palette = rev(hcl.colors(256L, "RdYlBu"))
)
}
\arguments{
\item{mapping}{Two-column matrix giving \emph{x} and \emph{y} coordinates of plotted
points.}

\item{mstEnds}{Two-column matrix identifying rows of \code{mapping} at end of
each edge of the MST, as output by \code{\link[TreeTools:MSTEdges]{TreeTools::MSTEdges()}}.}

\item{\dots}{Additional arguments to \code{\link[=segments]{segments()}}.}

\item{distances}{Matrix or \code{dist} object giving original distances between
each pair of points.}

\item{palette}{Vector of colours with which to colour edges.}
}
\value{
\code{StrainCol()} returns a vector in which each entry is selected from
\code{palette}, with an attribute \code{logStrain} denoting the logarithm of the
mapped over original distance, shifted such that the median value is zero.
Palette colours are assigned centred on the median value, with entries
early in \code{palette} assigned to edges in which the ratio of mapped
distance to original distance is small.
}
\description{
To identify strain in a multidimensional scaling of distances, it can be
useful to plot a minimum spanning tree
\insertCite{Gower1966,SmithSpace}{TreeDist}.  Colouring each edge of the
tree according to its strain can identify areas where the mapping is
stretched or compressed.
}
\examples{
set.seed(0)
library("TreeTools", quietly = TRUE)
distances <- ClusteringInfoDist(as.phylo(5:16, 8))
mapping <- cmdscale(distances, k = 2)
mstEnds <- MSTEdges(distances)

# Set up blank plot
plot(mapping, asp = 1, frame.plot = FALSE, ann = FALSE, axes = FALSE,
     type = "n")
# Add MST
MSTSegments(mapping, mstEnds, 
            col = StrainCol(distances, mapping, mstEnds))
# Add points at end so they overprint the MST
points(mapping)
SpectrumLegend(legend = c("Contracted", "Median", "Extended"),
               palette = rev(hcl.colors(256L, "RdYlBu")))
}
\references{
\insertAllCited{}
}
\seealso{
Other tree space functions: 
\code{\link{MapTrees}()},
\code{\link{MappingQuality}()},
\code{\link{SpectralEigens}()},
\code{\link{cluster-statistics}},
\code{\link{median.multiPhylo}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree space functions}
