% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpl_morphyex.R
\name{mpl_first_up_recon}
\alias{mpl_first_up_recon}
\title{Reconstructs the second (uppass) nodal reconstructions.}
\usage{
mpl_first_up_recon(node_id, left_id, right_id, anc_id, morphyobj)
}
\arguments{
\item{node_id}{The index of the node being reconstructed.}

\item{left_id}{The index of the left descendant.}

\item{right_id}{The index of the right descendant.}

\item{anc_id}{The index of the immediate ancestor of the node.}

\item{morphyobj}{An instance of the Morphy object.}
}
\value{
A null value (for now).
}
\description{
Reconstructs second-pass nodal sets. For normal (all-applicable)
characters, this is the final pass. This function is called over a preorder
sequence of nodes where left, right, and ancestral nodes are known.
Because this function needs to be fairly high-performance, it does not do much
checking for parameter validity, thus unsafe usage of this function might not
be caught. It is up to calling functions to ensure that the appropriate
parameters have been set before use.
}
\author{
Thomas Guillerme
}
\keyword{internal}
