% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Concordance.R
\name{SiteConcordance}
\alias{SiteConcordance}
\alias{QuartetConcordance}
\alias{ClusteringConcordance}
\alias{PhylogeneticConcordance}
\alias{MutualClusteringConcordance}
\alias{SharedPhylogeneticConcordance}
\title{Calculate site concordance factor}
\usage{
QuartetConcordance(tree, dataset = NULL)

ClusteringConcordance(tree, dataset)

PhylogeneticConcordance(tree, dataset)

MutualClusteringConcordance(tree, dataset)

SharedPhylogeneticConcordance(tree, dataset)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class
\code{phyDat}, whose names correspond to the labels of any accompanying tree.}
}
\description{
The site concordance factor \insertCite{Minh2020}{TreeSearch} is a measure
of the strength of support that the dataset presents for a given split in a
tree.
}
\details{
\code{QuartetConcordance()} is the proportion of quartets (sets of four leaves)
that are decisive for a split which are also concordant with it.
For example, a quartet with the characters \verb{0 0 0 1} is not decisive, as
all relationships between those leaves are equally parsimonious.
But a quartet with characters \verb{0 0 1 1} is decisive, and is concordant
with any tree that groups the first two leaves together to the exclusion
of the second.

NOTE: These functions are under development, and may be incompletely tested
or change without notice.
Complete documentation and discussion will follow in due course.
}
\examples{
data("congreveLamsdellMatrices", package = "TreeSearch")
dataset <- congreveLamsdellMatrices[[1]][, 1:20]
tree <- referenceTree
qc <- QuartetConcordance(tree, dataset)
cc <- ClusteringConcordance(tree, dataset)
pc <- PhylogeneticConcordance(tree, dataset)
spc <- SharedPhylogeneticConcordance(tree, dataset)
mcc <- MutualClusteringConcordance(tree, dataset)

oPar <- par(mar = rep(0, 4), cex = 0.8)
plot(tree)
TreeTools::LabelSplits(tree, signif(qc, 3))
TreeTools::LabelSplits(tree, signif(cc, 3))
TreeTools::LabelSplits(tree, signif(pc, 3))
par(oPar)

pairs(cbind(qc, cc, pc, spc, mcc))
}
\references{
\insertAllCited{}
}
\seealso{
Other split support functions: 
\code{\link{JackLabels}()},
\code{\link{Jackknife}()},
\code{\link{MaximizeParsimony}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split support functions}
