% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_generation.R
\name{NJTree}
\alias{NJTree}
\title{Neighbour Joining Tree}
\usage{
NJTree(dataset)
}
\arguments{
\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}},
whose names correspond to the labels of any accompanying tree.}
}
\value{
\code{NJTree} returns an object of class \code{phylo}.
}
\description{
Generates a rooted neighbour joining tree, with no edge lengths.
}
\examples{
data('Lobo')
NJTree(Lobo.phy)

}
\seealso{
Other tree generation functions: 
\code{\link{BalancedTree}()},
\code{\link{PectinateTree}()},
\code{\link{RandomTree}()},
\code{\link{SingleTaxonTree}()},
\code{\link{TreeNumber}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree generation functions}
