% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_properties.R
\name{DescendantEdges}
\alias{DescendantEdges}
\alias{AllDescendantEdges}
\title{Identify descendant edges}
\usage{
DescendantEdges(parent, child, edge = NULL, nEdge = length(parent))

AllDescendantEdges(parent, child, nEdge = length(parent))
}
\arguments{
\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree[["edge"]][, 1]}}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree[["edge"]][, 2]}.}

\item{edge}{Integer specifying the number of the edge whose child edges are
required (see \code{\link[ape:nodelabels]{edgelabels}()}).}

\item{nEdge}{number of edges (calculated from \code{length(parent)} if not
supplied).}
}
\value{
\code{DescendantEdges()} returns a logical vector stating whether each
edge in turn is a descendant of the specified edge (or the edge itself).

\code{AllDescendantEdges()} is deprecated; use \code{DescendantEdges()}
instead.
It returns a matrix of class logical, with row \emph{N} specifying whether each
edge is a descendant of edge \emph{N} (or the edge itself).
}
\description{
Quickly identify edges that are "descended" from edges in a tree.
}
\seealso{
Other tree navigation: 
\code{\link{AncestorEdge}()},
\code{\link{CladeSizes}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{ListAncestors}()},
\code{\link{MRCA}()},
\code{\link{NDescendants}()},
\code{\link{NodeDepth}()},
\code{\link{NodeOrder}()},
\code{\link{RootNode}()}
}
\concept{tree navigation}
