% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_rearrangement.R
\name{MakeTreeBinary}
\alias{MakeTreeBinary}
\title{Generate binary tree by collapsing polytomies}
\usage{
MakeTreeBinary(tree)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}
}
\value{
\code{MakeTreeBinary()} returns a rooted binary tree of class \code{phylo},
corresponding to tree uniformly selected from all those compatible with
the input tree topologies.
}
\description{
\code{MakeTreeBinary()} resolves, at random, all polytomies in a tree or set of
trees, such that all trees compatible with the input topology are drawn
with equal probability.
}
\examples{
MakeTreeBinary(CollapseNode(PectinateTree(7), c(9, 11, 13)))
UnrootTree(MakeTreeBinary(StarTree(5)))
}
\seealso{
Since ape v5.5, this functionality is available through
\code{\link[ape:multi2di]{ape::multi2di()}}; previous versions of 'ape' did not return topologies
in equal frequencies.

Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{EnforceOutgroup}()},
\code{\link{ImposeConstraint}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{Renumber}()},
\code{\link{RootTree}()},
\code{\link{SingleTaxonTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree manipulation}
