% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_files.R
\name{NewickTree}
\alias{NewickTree}
\title{Write Newick Tree}
\usage{
NewickTree(tree)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}
}
\value{
\code{NewickTree()} returns a character string denoting \code{tree} in Newick
format.
}
\description{
\code{NewickTree()} encodes a tree as a Newick-format string.
This differs from \code{\link[ape:write.tree]{write.tree()}} in the encoding of
spaces as spaces, rather than underscores.
}
\examples{
NewickTree(BalancedTree(LETTERS[4:9]))

}
\seealso{
Use tip numbers, rather than leaf labels: \code{\link{as.Newick}}
}
