% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msl.screenplot.R
\name{msl.screenplot}
\alias{msl.screenplot}
\title{Plotting to filescreen options.}
\usage{
msl.screenplot(x, type = 1, ci = 1)
}
\arguments{
\item{x}{object of class \dQuote{msl.trend} (see \code{\link{msl.trend}}) or
\dQuote{custom.trend} (see \code{\link{custom.trend}}).}

\item{type}{numeric, enables a user defined input to select the type of chart
to be plotted. 5 seperate options are available:

\itemize{
  \item 1: The default setting provides a single 3 panel chart with the time
  series in the top panel, velocity in the middle panel and acceleration in
  the bottom panel;
  \item 2: Single panel plot of time series;
  \item 3: Single panel plot of velocity;
  \item 4: Single panel plot of acceleration; and
  \item 5: Alternative 2 panel chart with the time series in the top panel
  and velocity in the bottom panel.
}}

\item{ci}{numeric, enables a user defined input to select the type of
confidence interval to be displayed on the plots. The default setting (ci = 1)
corresponds to a 95\% confidence interval whilst ci = 2 provides a 99\%
confidence interval.}
}
\description{
Plotting to filescreen options.
}
\details{
This function provides summary plots direct to the screen for both
\dQuote{msl.trend} (see \code{\link{msl.trend}}) and \dQuote{custom.trend}
(see \code{\link{custom.trend}}) objects. The same range of alternative plotting
to file options (in JPEG format) are available via \code{\link{msl.fileplot}}.
}
\examples{

# Plot to screen from "msl.trend" object

data(s) # "msl.trend" object
str(s) # check object

msl.screenplot(s) # default screen plot output, 3 panels, 95\% confidence intervals
msl.screenplot(s, type=2) # plot time series, 95\% confidence intervals
msl.screenplot(s, type=3) # plot velocity, 95\% confidence intervals
msl.screenplot(s, type=4, ci=2) # plot acceleration, 99\% confidence intervals
msl.screenplot(s, type=5, ci=2) # 2 panels, 99\% confidence intervals

}
\seealso{
\code{\link{msl.trend}}, \code{\link{custom.trend}},
\code{\link{msl.fileplot}}
}
