% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_Millar.R
\name{select_Millar}
\alias{select_Millar}
\title{Millar's selectivity model}
\source{
https://www.stat.auckland.ac.nz/~millar/selectware/
}
\usage{
select_Millar(param, x0, rtype = "norm.loc", rel.power = NULL,
  plot = TRUE)
}
\arguments{
\item{param}{A list with following parameters: vector with midlengths of size classes
(\code{midLengths}), vector with meshSizes in increasing order (\code{meshSizes}),
and a matrix with the number of individuals caught with each sized mesh
(\code{CatchPerNet_mat}).}

\item{x0}{A string of initial values for the parameters to be optimized over when applying the
function \code{\link[stats]{optim}}.}

\item{rtype}{A character string indicating which method for estimating selection curves
should be used:
\code{"norm.loc"} for a normal curve with common spread,
\code{"norm.sca"} for a normal curve with variable spread,
\code{"lognorm"} for a lognormal curve,
\code{"binorm.sca"} for a bi-normal curve,
\code{"bilognorm"} for a bi-lognormal curve,
\code{"tt.logistic"} for a control and logistic curve}

\item{rel.power}{A string indicating the relative power of different meshSizes,
must have same length as \code{meshSizes} (Default: \code{rel.power = NULL}).}

\item{plot}{logical; should a plot be printed?}
}
\description{
This model estimates the selecitvity of different gears from experimental
   catches.
}
\details{
Model adapted from the selectivity functions provided by Prof. Dr. Russell Millar
  (https://www.stat.auckland.ac.nz/~millar/). In the deviance plot open circles correspond to negative,
  closed to positive residuals. The size of the circles is proportional to the square of the residuals.
  To assess the model fit by the deviance plot it requires some experience, in general the pattern should
  be random and the sizes not too big. Please refer to Millar's publications and other publications for
  comparison. The model can produce errors if the starting values (\code{x0}) for the \link{optim}
  function are not realistic. Please be aware that if the method is changed the outcoming parameters
  can greatly vary. Simliarly the starting values have to be adapted when changing the method (\code{rtype}).
}
\examples{
# Trouser trawl net
data(haddock)

output <- select_Millar(haddock, x0 = c(-10,0.3,0),
   rtype = "tt.logistic")

plot(output, plotlens=seq(25,35,0.1), deviance_plot = FALSE)
legend(32,0.5,c("Control","Experimental"),lty=1:2,col=1:2,cex=0.8,bg="white")


# Gillnet
data(gillnet)

select_Millar(gillnet, x0 = c(10,3), rtype = "lognorm")
output <- select_Millar(gillnet, x0 = c(60,4), rtype = "norm.loc", plot=FALSE)

plot(output,plotlens=seq(40,90,0.1))


# Stacked trammel net
# The data come from two experiments using different mesh sizes
# This analysis assumes common retention curve in both experiments.
# Note that summary function does not produce residual plot
# since lengths are not unique
data(trammelnet)

output <- select_Millar(trammelnet, x0 = c(25,4),
   rtype="norm.loc", rel.power = rep(1,6))

plot(output,plotlens=seq(10,40,0.1))

}
\references{
Millar, R. B., Holst, R., 1997. Estimation of gillnet and hook selectivity
 using log-linear models. \emph{ICES Journal of Marine Science: Journal du Conseil},
 54(3):471-477

 Holt, S. J. 1963. A method for determining gear selectivity and its application.
 \emph{ICNAF Special Publication}, 5: 106-115.
}

