% Generated by roxygen2 (4.0.0): do not edit by hand
\name{turtle_move}
\alias{turtle_backward}
\alias{turtle_forward}
\alias{turtle_move}
\title{Move the Turtle Forward or Backward}
\usage{
turtle_move(distance, direction = c("forward", "backward"))

turtle_forward(distance)

turtle_backward(distance)
}
\arguments{
\item{distance}{single numeric value; specifies the distance to make.
Negative distance results in moving in the opposite direction.}

\item{direction}{character string; moving direction.
       One of \code{"forward"} or \code{"backward"}.}
}
\description{
\code{turtle_forward} moves the Turtle in forward direction and
\code{turtle_backward} moves the Turtle back.
}
\details{
The Turtle must be initialized prior to using
these functions, see \code{\link{turtle_init}}.

These functions make use of the Turtle's display options specified by
the \code{\link{turtle_param}} function
(or if not, use the default options set by \code{\link{turtle_init}}).

Note that if \code{\link{turtle_up}} or \code{\link{turtle_down}}
was called, the Turtle's trace will be or not be drawn, respectively.

If you are willing to call these functions in an R loop,
you may want to hide the Turtle temporarily (see \code{\link{turtle_hide}}
and \code{\link{turtle_do}})
before making actual moves. This will increase the drawing performance
significantly.
}
\examples{
turtle_init()
turtle_left(30)
turtle_forward(2)
turtle_up()
turtle_forward(1)
turtle_down()
turtle_right(60)
turtle_forward(9)
}
\seealso{
Other TurtleGraphics: \code{\link{TurtleGraphics-package}};
  \code{\link{turtle_col}}, \code{\link{turtle_lty}},
  \code{\link{turtle_lwd}}, \code{\link{turtle_param}};
  \code{\link{turtle_down}}, \code{\link{turtle_up}};
  \code{\link{turtle_do}}; \code{\link{turtle_getangle}},
  \code{\link{turtle_getpos}}; \code{\link{turtle_goto}},
  \code{\link{turtle_setangle}},
  \code{\link{turtle_setpos}}; \code{\link{turtle_hide}},
  \code{\link{turtle_show}}; \code{\link{turtle_init}};
  \code{\link{turtle_left}}, \code{\link{turtle_right}},
  \code{\link{turtle_turn}}; \code{\link{turtle_reset}};
  \code{\link{turtle_status}}
}

