% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_tweets.R
\name{pool_tweets}
\alias{pool_tweets}
\title{Prepare Tweets for topic modeling by pooling}
\usage{
pool_tweets(
  data,
  remove_numbers = TRUE,
  remove_punct = TRUE,
  remove_symbols = TRUE,
  remove_url = TRUE,
  remove_emojis = TRUE,
  remove_users = TRUE,
  remove_hashtags = TRUE,
  cosine_threshold = 0.9,
  stopwords = "en",
  n_grams = 1L
)
}
\arguments{
\item{data}{Data frame of parsed tweets. Obtained either by using \code{\link{load_tweets}}  or
\code{\link[jsonlite]{stream_in}} in conjunction with \code{\link[rtweet]{tweets_with_users}}.}

\item{remove_numbers}{Logical. If \code{TRUE} remove tokens that consist only of numbers,
but not words that start with digits, e.g. 2day. See \link[quanteda]{tokens}.}

\item{remove_punct}{Logical. If \code{TRUE} remove all characters in the Unicode
"Punctuation" [P] class, with exceptions for those used as prefixes for valid social media tags if
\code{preserve_tags = TRUE}. See \link[quanteda]{tokens}}

\item{remove_symbols}{Logical. If \code{TRUE} remove all characters in the Unicode "Symbol" [S] class.}

\item{remove_url}{Logical. If \code{TRUE} find and eliminate URLs beginning with http(s).}

\item{remove_emojis}{Logical. If \code{TRUE} all emojis will be removed from tweets.}

\item{remove_users}{Logical. If \code{TRUE} will remove all mentions of user names from documents.}

\item{remove_hashtags}{Logical. If \code{TRUE} will remove hashtags (not only the symbol but the hashtagged word itself) from documents.}

\item{cosine_threshold}{Double. Value between 0 and 1 specifying the cosine similarity threshold to be used
for document pooling. Tweets without a hashtag will be assigned to document (hashtag) pools
based upon this metric. Low thresholds will reduce topic coherence by including
a large number of tweets without a hashtag into the document pools. Higher thresholds will lead
to more coherent topics but will reduce document sizes.}

\item{stopwords}{a character vector, list of character vectors, \link[quanteda]{dictionary}
or collocations object. See \link[quanteda]{pattern} for details.
Defaults to \link[stopwords:stopwords]{stopwords("english")}.}

\item{n_grams}{Integer vector specifying the number of elements to be concatenated in each n-gram.
Each element of this vector will define a n in the n-gram(s) that are produced. See \link[quanteda]{tokens_ngrams}}
}
\value{
List with \link[quanteda]{corpus} object and \link[quanteda]{dfm} object of pooled tweets.
}
\description{
This function pools a data frame of parsed tweets into document pools.
}
\details{
Pools tweets by hashtags using cosine similarity to create
longer pseudo-documents for better LDA estimation and creates n-gram tokens.
The method applies an implementation of the pooling algorithm from Mehrotra et al. 2013.
}
\examples{

\dontrun{

library(Twitmo)

# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

pool <- pool_tweets(data = mytweets,
                    remove_numbers = TRUE,
                    remove_punct = TRUE,
                    remove_symbols = TRUE,
                    remove_url = TRUE,
                    remove_users = TRUE,
                    remove_hashtags = TRUE,
                    remove_emojis = TRUE,
                    cosine_threshold = 0.9,
                    stopwords = "en",
                    n_grams = 1)
}
}
\references{
Mehrotra, Rishabh & Sanner, Scott & Buntine, Wray & Xie, Lexing. (2013).
Improving LDA Topic Models for Microblogs via Tweet Pooling and Automatic Labeling.
889-892. 10.1145/2484028.2484166.
}
\seealso{
\link[quanteda]{tokens}, \link[quanteda]{dfm}
}
