% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{WeightsGLSkew}
\alias{WeightsGLSkew}
\title{Site gauged linear skewness (LSkew) weightings}
\usage{
WeightsGLSkew(x)
}
\arguments{
\item{x}{pooling group derived with the Pool() function}
}
\value{
A data.frame with site references in the first column and associated weights in the second
}
\description{
Provides the gauged LSkew weights for each site in a pooling group
}
\details{
Weighting method as according to Science Report: SC050050 - Improving the FEH statistical procedures for flood frequency estimation
}
\examples{
#Get some CDs, form a gauged pooling group, and estimate gauged LSkew
CDs.27051 <- GetCDs(27051)
Pool.27051 <- Pool(CDs.27051)
WeightsGLSkew(Pool.27051)
}
\author{
Anthony Hammond
}
