% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UMRgradDesc.R
\name{UMRgradDesc}
\alias{UMRgradDesc}
\alias{gradDesc}
\title{Basic gradient descent implementation}
\usage{
gradDesc(yy, grad, init, stepsize, MM, printevery, filename)
}
\arguments{
\item{yy}{Y (response) observation vector (numeric)}

\item{grad}{a function(yy, mm) where mm is same length of yy and is the
previous iterate value (i.e., the estimate vector).}

\item{init}{Initial value of estimate ('mm').  I.e., numeric vector of same length as yy.}

\item{stepsize}{Gradient descent stepsize.  Set carefully! (I often use
nn^2 / 2 where nn = length(yy), or nn if gradient is 'rescaled'.)}

\item{MM}{Number of iterations}

\item{printevery}{integer value (generally << MM).  Every 'printevery' iterations, a count will be printed and the output saved.}

\item{filename}{filename (path) to save output to.}
}
\description{
Basic gradient descent implementation
}
\details{
Implements a very basic gradient descent. Right now stepsize is fixed.
}
\examples{


#### Set up the gradient function 
 mysig <- 1 ##  std dev
errdist <- distr::Norm(0, sd=mysig)
modeldistname <- truedistname <- "Gauss" ## used for savefile name
mm0 <- function(xx){xx}
nn <- 300
xx <- sort(runif(n=nn, 0, 7))
yy <- mm0(xx) + errdist@r(nn)
## plot(xx,yy)

myScale <- mysig

AAfunc_Gauss <- purrr::partial(AAfunc_Gauss_generic, sig=!!mysig)
AA_Gauss <- purrr::partial(AA, func=!!AAfunc_Gauss)
BBfunc_Gauss <- purrr::partial(BBfunc_Gauss_generic, sig=!!mysig)
BB_Gauss <- purrr::partial(BB, func=!!BBfunc_Gauss)
mygradSIR <- 
    grad_SIR_Gauss <- ## just for ease of reference
        purrr::partial(grad_SIR_generic,
                       rescale=TRUE, ## factor of nn/2
                       AAfunc=!!AA_Gauss, BBfunc=!!BB_Gauss)

 ## Now run the gradient descent
savefilenameUnique <- paste("graddesc_", modeldistname, "_", truedistname,
                            "_n", nn,
                            "_", format(Sys.time(), "\%Y-\%m-\%d-\%T"), ".rsav", sep="")
print(paste("The unique save file name for this run is", savefilenameUnique))
stepsize <- nn^(1/2) ## Has to be tuned
MM <-  100 ## Total number iterations is MM * JJ 
JJ <- 2
eps <- (max(yy)-min(yy)) / (1000 * nn^(1/5) * myScale)
## print *and* SAVE every 'printevery' iterations.
## here no save occurs, printevery > MM
printevery <- 1000 
init <- yy

mmhat <- UMRgradDesc(yy=yy, grad=mygradSIR, ## from settings file
                     init=init,
                     stepsize=stepsize, MM=MM,
                     printevery=printevery,
                     filename=paste0("../saves/", savefilenameUnique))
#### some classical/matched [oracle] estimators
isoreg_std <- Iso::ufit(y=yy, x=xx, lmode=Inf)
mmhat_std = isoreg_std$y ## Isotonic regression
linreg_std <- lm(yy~xx)

}
