\name{SPSlogit}
\alias{SPSlogit}
\title{Propensity Score prediction of Treatment Selection from Patient Baseline X-covariates}
\description{Use a logistic regression model to predict Treatment Selection from Patient
  Baseline X-covariates in Supervised Propensity Scoring.}
\usage{
  SPSlobj <- SPSlogit(dframe, form, pfit, prnk, qbin, bins=5, appn="")
}
\arguments{
  \item{dframe}{Name of data.frame containing X, t and Y variables.}
  \item{form}{Valid formula for glm()with family = binomial(), with the two-level treatment
   factor variable as the left-hand-side of the formula.}
  \item{pfit}{Name of variable to store PS predictions.}
  \item{prnk}{Name of variable to store tied-ranks of PS predictions.}
  \item{qbin}{Name of variable to store the assigned bin number for each patient.}
  \item{bins}{optional; number of adjacent PS bins desired; default to 5.}
  \item{appn}{optional; append the pfit, prank and qbin variables to the input dfname when
   appn=="", else save augmented data.frame to name specified within a non-blank appn string.}
}
\details{The first phase of Supervised Propensity Scoring is to develop a logit (or probit) model
  predicting treatment choice from patient baseline X characteristics.  SPSlogit uses a call to
  glm()with family = binomial() to fit a logistic regression.
}
\value{ An output list object of class SPSlogit:
  \item{dframe}{Name of input data.frame containing X, t & Y variables.}
  \item{dfoutnam}{Name of output data.frame augmented by pfit, prank and qbin variables.}
  \item{trtm}{Name of two-level treatment factor variable.}
  \item{form}{glm() formula for logistic regression.}
  \item{pfit}{Name of predicted PS variable.}
  \item{prank}{Name of variable containing PS tied-ranks.}
  \item{qbin}{Name of variable containing assigned PS bin number for each patient.}
  \item{bins}{Number of adjacent PS bins desired.}
  \item{glmobj}{Output object from invocation of glm() with family = binomial().}
}
\references{
  Cochran WG. (1968) The effectiveness of adjustment by subclassification
  in removing bias in observational studies. \emph{Biometrics} \bold{24}:
  205--213.

  Kereiakes DJ, Obenchain RL, Barber BL, et al. (2000) Abciximab provides
  cost effective survival advantage in high volume interventional practice.
  \emph{Am Heart J} \bold{140}: 603--610.

  Obenchain RL. (2005) \bold{USPSinR.pdf}  ../R\_HOME/library/USPS  40 pages.

  Rosenbaum PR, Rubin RB. (1983) The Central Role of the Propensity Score
  in Observational Studies for Causal Effects. \emph{Biometrika} \bold{70}:
  41--55.

  Rosenbaum PR, Rubin DB. (1984) Reducing Bias in Observational Studies
  Using Subclassification on a Propensity Score. \emph{J Amer Stat Assoc}
  \bold{79}: 516--524.
}
\author{Bob Obenchain <sunsetstats@earthlink.net>}
\seealso{\code{\link{SPSbalan}}, \code{\link{SPSnbins}} and \code{\link{SPSoutco}}.}
\examples{
  data(lindner)
  PStreat <- abcix~stent+height+female+diabetic+acutemi+ejecfrac+ves1proc
  logtSPS <- SPSlogit(lindner, PStreat, PSfit, PSrnk, PSbin, appn="lindSPS")
  logtSPS
}
\keyword{models}