\name{UPSivadj}
\alias{UPSivadj}
\title{Instrumental Variable LATE Linear Fitting in Unsupervised Propensiy Scoring}
\description{For a given number of patient clusters in baseline X-covariate space and a
  specified Y-outcome variable, linearly smooth the distribution of Local Average
  Treatment Effects (LATEs) plotted versus Within-Cluster Treatment Selection (PS)
  Percentages.}
\usage{
  UPSivadj(numclust)
}
\arguments{
  \item{numclust}{Number of clusters in baseline X-covariate space.}
}
\details{Multiple calls to UPSivadj(n) for varying numbers of clusters n are made after first
  invoking UPShclus() to hierarchically cluster patients in X-space and then invoking UPSaccum()
  to specify a Y outcome variable and a two-level treatment factor t.  UPSivadj(n) linearly
  smoothes the LATE distribution when plotted versus within cluster propensity score percentages.
}
\value{ An output list object of class UPSivadj:
  \item{hiclus}{Name of clustering object created by UPShclus().}
  \item{dframe}{Name of data.frame containing X, t & Y variables.}
  \item{trtm}{Name of treatment factor variable.}
  \item{yvar}{Name of outcome Y variable.}
  \item{numclust}{Number of clusters requested.}
  \item{actclust}{Number of clusters actually produced.}
  \item{scedas}{Scedasticity assumption: "homo" or "hete"}
  \item{PStdif}{Character string describing the treatment difference.}
  \item{ivhbindf}{Vector containing cluster number for each patient. }
  \item{rawmean}{Unadjusted outcome mean by treatment group.}
  \item{rawvars}{Unadjusted outcome variance by treatment group.}
  \item{rawfreq}{Number of patients by treatment group.}
  \item{ratdif}{Unadjusted mean outcome difference between treatments.}
  \item{ratsde}{Standard error of unadjusted mean treatment difference.}
  \item{binmean}{Unadjusted mean outcome by cluster and treatment.}
  \item{binfreq}{Number of patients by bin and treatment.}
  \item{faclev}{Maximum number of different numerical values an outcome variable can assume without
   automatically being converted into a "factor" variable; faclev=1 causes a binary indicator to be
   treated as a continuous variable determining an average or proportion.}
  \item{youtype}{"contin"uous => next eleven outputs; "factor" => no additional output items.}
  \item{pbinout}{LATE regardless of treatment by cluster.}
  \item{pbinpsp}{Within-Cluster Treatment Percentage = non-parametric Propensity Score.}
  \item{pbinsiz}{Cluster radii measure: square root of total number of patients.}
  \item{symsiz}{Symbol size of largest possible Snowball in a UPSivadj() plot with 1 cluster.}
  \item{ivfit}{lm() output for linear smooth across clusters.}
  \item{ivtzero}{Predicted outcome at PS percentage zero.}
  \item{ivtxsde}{Standard deviation of outcome prediction at PS percentage zero.}
  \item{ivtdiff}{Predicted outcome difference for PS percentage 100 minus that at zero.}
  \item{ivtdsde}{Standard deviation of outcome difference.}
  \item{ivt100p}{Predicted outcome at PS percentage 100.}
  \item{ivt1pse}{Standard deviation of outcome prediction at PS percentage 100.}
}
\references{
  Imbens GW, Angrist JD. (1994) Identification and Estimation  of
  Local Average Treatment Effects (LATEs). \emph{Econometrica} \bold{62}: 467-475.

  Obenchain RL. (2004) Unsupervised Propensity Scoring: NN and IV Plots.
  \emph{Proceedings of the American Statistical Association (on CD)} 8 pages.

  Obenchain RL. (2011) \bold{USPSinR.pdf}  USPS R-package vignette, 40 pages.-

  McClellan M, McNeil BJ, Newhouse JP. (1994) Does More Intensive Treatment of
  Myocardial Infarction in the Elderly Reduce Mortality?: Analysis Using Instrumental
  Variables. \emph{JAMA} \bold{272}: 859-866.

  Rosenbaum PR, Rubin RB. (1983) The Central Role of the Propensity Score
  in Observational Studies for Causal Effects. \emph{Biometrika} \bold{70}:
  41-55.
}
\author{Bob Obenchain <wizbob@att.net>}
\seealso{\code{\link{UPSnnltd}}, \code{\link{UPSaccum}} and \code{\link{UPSgraph}}.}
\examples{
  data(lindner)
  UPSxvars <- c("stent", "height", "female", "diabetic", "acutemi", "ejecfrac", "ves1proc")
  UPSharch <- UPShclus(lindner, UPSxvars)
  UPSaccum(UPSharch, lindner, abcix, lifepres, faclev=1, scedas="homo", accobj="ABClife")

  lif100iv <- UPSivadj(100)
  lif100iv
  plot(lif100iv)
}
\keyword{nonparametric}
\keyword{hplot}