% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UDtable.R
\name{UDtable}
\alias{UDtable}
\alias{UD_table}
\alias{UD_table.UD_model}
\alias{UD_table.UD_stage}
\title{Make uncertainty table}
\usage{
UD_table(UD, ...)

\method{UD_table}{UD_model}(UD, include.nat = TRUE, include.tot = TRUE,
  ...)

\method{UD_table}{UD_stage}(UD, include.nat = TRUE, include.tot = TRUE,
  ...)
}
\arguments{
\item{UD}{model wise uncertainty or stage wise uncertainty}

\item{...}{further arguments passed to or from other methods. include.nat or include.tot}

\item{include.nat}{If include.nat is TRUE and UD has nat_unc, create a table containing it.}

\item{include.tot}{If include.tot is TRUE, create a table containing it.}
}
\value{
uncertainty table
}
\description{
This function summarizes the uncertainty into a table.
}
\examples{
set.seed(0)
stage1 <- LETTERS[1:3]
stage2 <- LETTERS[1:2]
stage3 <- LETTERS[1:4]
y <- rnorm(3*2*4)
data <- expand.grid(stage1=stage1,
                    stage2=stage2,
                    stage3=stage3)
data <- cbind(data, y)

UD_bal_model_range <- UD_bal_model(data, "y", names(data)[-4], u_range, flist_range)
UD_bal_model_range 

UD_bal_stage_range <- UD_model2stage(UD_bal_model_range)
UD_bal_stage_range 

UD_table(UD_bal_model_range)
UD_table(UD_bal_stage_range)
}
