% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarize.VCA}
\alias{summarize.VCA}
\alias{summarize.VCAinference}
\title{Summarize Outcome of a Variance Component Analysis.}
\usage{
summarize.VCA(
  object,
  type = c("sd", "cv"),
  tail = "one-sided",
  ends = "upper",
  conf.level = 0.95,
  DF = TRUE,
  as.df = FALSE,
  print = TRUE
)
}
\arguments{
\item{object}{(object) of class \code{VCA} or \code{VCAinference} or a list of
these objects to be summarized.}

\item{type}{(character) "sd" for standard devation, "cv" for coefficient of 
variation, and "vc" for variance defining on which scale results
shall be returned. Multiple can be specified.}

\item{tail}{(character) "one-sided" for one-sided CI, "two-sided" for two-sided CI,
can be abbreviated}

\item{ends}{(character) "upper" or "lower" bounds of a e.g. 95\% CI, can be both}

\item{conf.level}{(numeric) confidence level of the CI}

\item{DF}{(logical) TRUE to include degrees of freedom, FALSE to omit them}

\item{as.df}{(logical) TRUE to transpose the returned object and convert into
a data.frame, FALSE leve}

\item{print}{(logical) TRUE print summary, FALSE omit printing and just return
matrix or data.frame}
}
\value{
(matrix, data.frame) with VCA-results either with estimates in rows and sample(s)
			in columns, or vice versa
}
\description{
If a single 'VCA'-object is passed, the first step is to call 'VCAinference' for CI
estimation. For each variance component (VC) the result of the VCA is summarized
and can be configured by arguments 'type', 'tail', 'ends', and 'conf.level'. These
define which information is returned by this summary function. In case of passing
a list of 'VCA'- or 'VCAinference'-objects, a matrix will be returned where columns
correspond to list-elements, usually samples, and rows to estimated values. This is 
done as the number of estimated values usually exceeds the number of samples.
}
\examples{
\dontrun{
data(CA19_9)
fit.all <- anovaVCA(result~site/day, CA19_9, by="sample")
summary.VCA(fit.all)
# complete set of results
summary.VCA(	fit.all, type=c("vc", "sd", "cv"), tail=c("one", "two"),
				ends=c("lower", "upper"))
# summarizing a single VCA-object
summary(fit.all[[1]])
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
