% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfp.R
\name{summary.VFP}
\alias{summary.VFP}
\title{Summary Objects of Class 'VFP'}
\usage{
\method{summary}{VFP}(object, model.no = NULL, digits = 4,
  type = c("simple", "complex"), ...)
}
\arguments{
\item{object}{(object) of class 'VFP'}

\item{model.no}{(integer) specifying a fitted model in 'x', if NULL the best fitting
model will be printed, i.e. the one with min(RSS)}

\item{digits}{(integer) number of significant digits}

\item{type}{(character) "simple" = short summary, "complex" = calls the summary-method
for objects of class "gnm"}

\item{...}{additional parameters passed forward}
}
\description{
Summary Objects of Class 'VFP'
}
\examples{
\donttest{
library(VCA)
data(CA19_9)
fits.CA19_9 <- anovaVCA(result~site/day, CA19_9, by="sample")
# extract repeatability
mat.CA19_9 <- getMat.VCA(fits.CA19_9, "error")
res.CA19_9 <- fit.vfp(mat.CA19_9, 1:10)
summary(res.CA19_9)
print(res.CA19_9)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
