\docType{package}
\name{VFP-package}
\alias{VFP}
\alias{VFP-package}
\title{(V)ariance (F)unction (P)rogram}
\description{
 The intended use of this package is to implement variance functions proposed in Sadler's VFP stand-alone software 
 (see reference below), from which the name was borrowed as well. 
 Main function of this package is \code{\link{fit.vfp}} for fitting non-linear variance-function
 models. Usually, these models are fitted to analysis-results of precision performance data e.g.
 frequently generated for in-vitro diagnostics (IVD). R-package VFP is designed to work best on objects 
 of class 'VCA' as generated by R-package \code{VCA} but it is not restricted to these.
 There are several functions operating on S3-objects of class 'VFP', e.g. \code{\link{plot.VFP}},
 \code{\link{print.VFP}}, \code{\link{summary.VFP}}, and \code{\link{predict.VFP}}. Function \code{\link{predictMean}}
 is of special interest when a functional relationship is used to derive limit of quantitation (LoQ) or functional
 sensitivity, as the concentration at which the IVD-imprecision expressed as coefficient of variation (CV) undercuts
 a specific threshold.
 }
\details{
  \tabular{ll}{
    Package: \tab VFP\cr
    Type: \tab Package \cr
    Version: \tab 1.2 \cr
    Date: \tab 2019-12-17\cr
    License:  \tab GPL (>=3) \cr
    LazyLoad: \tab yes \cr
  }
}
\author{
	Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com},
	Florian Dufey \email{florian.dufey@roche.com},
	Andrea Geistanger \email{andrea.geistanger@roche.com}
}
\references{
CLSI EP05-A3: Evaluation of Precision of Quantitative Measurement Procedures; Approved Guideline - Third Edition. (2014)
Sadler WA, Smith MH. Use and Abuse of Imprecision Profiles: Some Pitfalls Illustarted by Computing and Plotting Confidence Intervals. Clin Chem 1990; 36/7:1346-1350
	
Sadler WA, Smith MH. A reliable method of estimating the variance function in immunoassays. Comput Stat Data Anal 1986; 3:227-239
	
Sadler WA, Smith MH. Estimation of imprecision in immunoassays quality assessment programmes. Ann Clin Biochem 1987; 24:98-102
	
Sadler WA, \href{http://www.aacb.asn.au/professionaldevelopment/useful-tools/variance-function-program-version-110}{http://www.aacb.asn.au/professionaldevelopment/useful-tools/variance-function-program-version-110}. Accessed November 16, 2015
}
\keyword{package}
