% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vosonSML.R
\name{collectTwitterData}
\alias{collectTwitterData}
\title{Collect twitter data}
\usage{
collectTwitterData(cred, search_term, search_type, tweet_count,
  include_retweets, retry_on_rate_limit, language, date_until, since_id,
  max_id)
}
\arguments{
\item{cred}{\pkg{vosonSML} twitter credential object.}

\item{search_term}{Character string. Twitter search term.}

\item{search_type}{Character string. Search type \code{"mixed"}, \code{"recent"} or \code{"popular"}.}

\item{tweet_count}{Numeric. Number of tweets to collect.}

\item{include_retweets}{Logical. Include retweets in the results.}

\item{retry_on_rate_limit}{Logical. Wait and retry when the twitter api rate limit is reached.}

\item{language}{Character string. Language code of tweets to collect as two character ISO 639-1 code.}

\item{date_until}{Character string. Date to collect tweets to in format \code{"YYYY-MM-DD"}.}

\item{since_id}{Numeric. Collect tweets with a tweet id more recent than \code{since_id}.}

\item{max_id}{Numeric. Collect tweets with a tweet id older than \code{max_id}.}
}
\value{
A vosonSML twitter dataframe.
}
\description{
This function is a wrapper for collecting tweets using \code{vosonSML::Collect}.
}
\keyword{internal}
