% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_code.R
\name{preplotperf}
\alias{preplotperf}
\title{Preprocess a \code{ksvm} object}
\usage{
preplotperf(model, mydata, indy, mytestdata, zerolevel = "zero",
  risklabel = "Estimated risk", adverse = FALSE)
}
\arguments{
\item{model}{Object of class \code{ksvm}}

\item{mydata}{Data on which \code{mymodel} was trained on.}

\item{indy}{Column number of the outcome in \code{mydata}.}

\item{mytestdata}{Data on which to evaluate \code{mymodel}.  (Optional)}

\item{zerolevel}{The value of the contributions that should be put to zero.  If "zero", the contributions are represented 
   as they are.  If "min", for each predictor or set of predictors contributing to an interaction, the minimal observed value 
   of the contribution in the training data is substracted from the contribution to ensure that the contribution is always positive.  
If "median" or "mean", the median or mean value is substracted from the contributions, respectively (default="zero").  See below for more details.}

\item{risklabel}{A character string representing the label for the represented risk. For  multinomial logistic regression models, a vector of risk labels should be provided. 
See the examples for an illustration of the approach.}

\item{adverse}{A logical indicating whether the score and risk range in the adverse direction (default=FALSE, i.e. high score corresponds to a high risk).}
}
\value{
List object
}
\description{
Performs necessary preprocessing of a \code{ksvm} object when the plots should be generated based on all training data and not only on the support vectors.
}
\details{
Depending on the value of \code{zerolevel}, the visualized contributions are slightly different.  
	If \code{zerolevel}="zero", the contribution for variable \eqn{x^p} is \eqn{\beta_pf_p(x^p)}, with \eqn{\beta_p} the model
	coefficient corresponding to this predictor and \eqn{f_p(x^p)} a (possible) transformation of \eqn{x^p}.  If \code{zerolevel} is "min", "median" or "mean", a value equal to 
	the minimum, median and mean of the contribution \eqn{\beta_pf_p(x^p)} in the training data, respectively, is substracted from the contribution.  See the references for more information.
}
\author{
Vanya Van Belle
}
\references{
Van Belle V., Van Calster B., Suykens J.A.K., Van Huffel S. and Lisboa P., \emph{Explaining support vector machines: a color based nomogram}, Internal Report 16-27, ESAT-Stadius, KU Leuven (Leuven, Belgium), 2016
}
\seealso{
\code{\link{colplot}}, \code{\link{cchart}}, \code{\link{ccchart}}
}

