% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbowDetection.R
\name{kneedle}
\alias{kneedle}
\title{Kneedle Algorithm: to detect elbow point(s) on the curve}
\usage{
kneedle(res, S = 10, auto.loose = TRUE, min.S = 0.1, loosing.factor = 0.5)
}
\arguments{
\item{res}{a dataframe with variables and observed frequency}

\item{S}{numeric, determines how aggressive the elbow points on the curve to be called, smaller means more aggressive and larger means more conservative}

\item{auto.loose}{if TRUE, will reduce `kneedle.S` in case no elbow point is found with the set `kneedle.S`}

\item{min.S}{a numeric value determines the minimal value that `kneedle.S` will be loosed to.}

\item{loosing.factor}{a numeric value range in (0,1), which `kneedle.S` is multiplied by to reduce itself.}
}
\value{
the original input dataframe along with the elbow point indicator "elbow.point" with elbow point(s) marked with "*", "Diff" the difference curve, "Thres" the threshold.
}
\description{
An internal function utilized by VSOLassoBag.
}
\examples{
load(system.file("extdata/Results.RData", package="VSOLassoBag"))
kneedle(Results)
}
\references{
\href{https://ieeexplore.ieee.org/document/5961514}{Original Kneedle Algorithm}, the algorithm utilized in LassoBag has been modified.
}
