% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_decomposition.R
\name{linear_projection}
\alias{linear_projection}
\title{Linear Projection}
\usage{
linear_projection(
  y,
  X.list,
  data,
  wgt = rep(1, nrow(data)),
  year = rep(1, nrow(data)),
  comp.names = NULL
)
}
\arguments{
\item{y}{a character specifying the name of the outcome variable (e.g. "wage").
Note that this variable is standardized before it's projected onto X.}

\item{X.list}{a list containing the names of all the variables needed for the linear projection, grouped
according to the components will later be used in the skewness decomposition. For example:
for X.list = list("x1", c("x2", "x3")) the following components are returned: \eqn{\beta1X1},
(\eqn{\beta2X2+ \beta3X3}), \eqn{\epsilon}. Currently interactions aren't supported,
so the user should insert them manually.}

\item{data}{a data frame with all the variables specified in X.list and y.}

\item{wgt}{an optional vector of weights.}

\item{year}{an optional vector of years. if provided, the projection is done for each year separately.}

\item{comp.names}{an optional vector specifying name for each component.}
}
\value{
a matrix with the (centered) components specified by X.list + residuals. Note that each row is summed (up to
a constant) to the standardized version of y, and each column to 0 (both by year).
}
\description{
estimates the linear model \eqn{y = \beta*X + \epsilon} and returns its linear
components, grouped according to X.list.
}
\examples{
#gen data
n <- 1000
X <- matrix(rnorm(n*3), ncol = 3)
colnames(X) <- c("x1", "x2", "x3")
beta <- c(1,2,3)
wage <- X \%*\% beta + rnorm(n)
dat <- as.data.frame(cbind(wage, X))
colnames(dat)[1] <- "wage"
res <- linear_projection("wage", X.list = list("x1", c("x2", "x3")), data = dat)
#each row is summed (up to a constant) to the standardized wage:
stand_wage <- (wage - mean(wage)) / sd(wage)
diff <- apply(res, 1, sum) - stand_wage
summary(diff)
}
