
# ---------------------------------------------------------------------------- #
#' masas
#' @description Lunar month in the Vedic calendar system
masas <- c(
  "Chaitra",
  "Vaishakha",
  "Jyeshtha",
  "Ashada",
  "Shravana",
  "Bhadrapada",
  "Ashvija",
  "Kartika",
  "Margashira",
  "Pushya",
  "Maagha",
  "Phalguna"
)

# ---------------------------------------------------------------------------- #
#' tithis
#' @description lunar day in the Vedic calendar system
tithis <- c(
  "Shukla paksha prathama",
  "Shukla paksha dvitiya",
  "Shukla paksha trititya",
  "Shukla paksha chaturthi",
  "Shukla paksha panchami",
  "Shukla paksha sashti",
  "Shukla paksha saptami",
  "Shukla paksha ashtami",
  "Shukla paksha navami",
  "Shukla paksha dashmi",
  "Shukla paksha ekadashi",
  "Shukla paksha dvadashi",
  "Shukla paksha trayodashi",
  "Shukla paksha chaturdashi",
  "Poornima",
  "Krishna paksha prathama",
  "Krishna paksha dvitiya",
  "Krishna paksha trititya",
  "Krishna paksha chaturthi",
  "Krishna paksha panchami",
  "Krishna paksha sashti",
  "Krishna paksha saptami",
  "Krishna paksha ashtami",
  "Krishna paksha navami",
  "Krishna paksha dashmi",
  "Krishna paksha ekadashi",
  "Krishna paksha dvadashi",
  "Krishna paksha trayodashi",
  "Krishna paksha chaturdashi",
  "Amavasya"
)

# ---------------------------------------------------------------------------- #
#' nakshatras
#' @description Name of the 27 Nakshatras in Vedic calendar system
nakshatras <- c(
  "Ashwini",
  "Bharani",
  "Kritika",
  "Rohini",
  "Mrigashira",
  "Ardra",
  "Punarvasu",
  "Pushya",
  "Ashlesha",
  "Magha",
  "Purvaphalguni",
  "Uttaraphalguni",
  "Hasta",
  "Chitra",
  "Swati",
  "Vishakha",
  "Anuradha",
  "Jyeshta",
  "Mula",
  "Purvashada",
  "Uttarashada",
  "Shravana",
  "Dhanishta",
  "Shatabhisha",
  "Purvabhadrapada",
  "Uttarabhadrapada",
  "Revati"
)

# ---------------------------------------------------------------------------- #
#' ritus
#' @description Name of the 6 seasons in Vedic calendar system
ritus <- c(
  "Vasanta",
  "Grishma",
  "Varsha",
  "Sharad",
  "Hemanta",
  "Sishira"
)

# ---------------------------------------------------------------------------- #
#' samvatsars
#' @description Name of the Year in Hindu Panchang
samvatsars <- c(
  "Prabhava",
  "Vibhava",
  "Sukla",
  "Pramoda",
  "Prajapati",
  "Angirasa",
  "Srimukha",
  "Bhava",
  "Yuva",
  "Dhatri",
  "Ishvara",
  "Bahudhanya",
  "Pramadhi",
  "Vikrama",
  "Vrushapraja",
  "Citrabhanu",
  "Subhanu",
  "Tarana",
  "Parthiva",
  "Vyaya",
  "Sarvajit",
  "Sarvadharin",
  "Virodhin",
  "Vikriti",
  "Khara",
  "Nandana",
  "Vijaya",
  "Jaya",
  "Manmatha",
  "Durmukhi",
  "Hevilambi",
  "Vilambi",
  "Vikari",
  "Sharvari",
  "Plava",
  "Shubhakrit",
  "Shobhakrit",
  "Krodhi",
  "Vishvavasu",
  "Parabhava",
  "Plavanga",
  "Kilaka",
  "Saumya",
  "Sadharana",
  "Virodhakruta",
  "Paridhavi",
  "Pramadi",
  "Ananda",
  "Rakshasa",
  "Nala",
  "Pingala",
  "Kalayukta",
  "Siddharti",
  "Raudra",
  "Durmati",
  "Dundubhi",
  "Rudhirodhgari",
  "Raktakshi",
  "Krodhana",
  "Akshaya"
)

# ---------------------------------------------------------------------------- #
#' yogas
#' @description Name of the 27 yogas which is sum of sidereal longitudes of sun and moon in the multiples of 13 degrees 20 minutes
yogas <- c(
  "Vishkhamba",
  "Preeti",
  "Ayushmaan",
  "Saubhaagya",
  "Sobhana",
  "Atiganda",
  "Sukarman",
  "Dhriti",
  "Shoola",
  "Ganda",
  "Vriddhi",
  "Dhruva",
  "Vyaaghaata",
  "Harshana",
  "Vajra",
  "Siddhi",
  "Vyatipaata",
  "Variyan",
  "Parigha",
  "Shiva",
  "Siddha",
  "Saadhya",
  "Subha",
  "Sukla",
  "Brahma",
  "Indra",
  "Vaidhriti"
)

# ---------------------------------------------------------------------------- #
#' karanas
#' @description Name of 60 Karanas which is when moon traverses 6° in longitude relative to the sun
karanas <- c(
  "Kimstughna",
  "Bava",
  "Baalava",
  "Kaulava",
  "Taitila",
  "Garaja",
  "Vanija",
  "Visti",
  "Bava",
  "Baalava",
  "Kaulava",
  "Taitila",
  "Garaja",
  "Vanija",
  "Visti",
  "Bava",
  "Baalava",
  "Kaulava",
  "Taitila",
  "Garaja",
  "Vanija",
  "Visti",
  "Bava",
  "Baalava",
  "Kaulava",
  "Taitila",
  "Garaja",
  "Vanija",
  "Visti",
  "Bava",
  "Baalava",
  "Kaulava",
  "Taitila",
  "Garaja",
  "Vanija",
  "Visti",
  "Bava",
  "Baalava",
  "Kaulava",
  "Taitila",
  "Garaja",
  "Vanija",
  "Visti",
  "Bava",
  "Baalava",
  "Kaulava",
  "Taitila",
  "Garaja",
  "Vanija",
  "Visti",
  "Bava",
  "Baalava",
  "Kaulava",
  "Taitila",
  "Garaja",
  "Vanija",
  "Visti",
  "Sakuni",
  "Chatushpada",
  "Naga"
)

# ---------------------------------------------------------------------------- #
#' rashis
#' @description The name of 12 Rashis which represents the position of the moon on the zodiac at a given time
rashis <- c(
  "Mesha",
  "Vrushabha",
  "Mithuna",
  "Karka",
  "Sinha",
  "Kanya",
  "Tula",
  "Vrushchik",
  "Dhanu",
  "Makara",
  "Kumbha",
  "Meena"
)

# ---------------------------------------------------------------------------- #
#' vaaras
#' @description Name of the day of the week
vaaras <- c(
  "Ravivar",
  "Somvar",
  "Mangalwar",
  "Budhwar",
  "Guruwar",
  "Shukrawar",
  "Shaniwar"
)
