% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiCopName.R
\name{BiCopName}
\alias{BiCopName}
\title{Bivariate Copula Family Names}
\usage{
BiCopName(family, short = TRUE)
}
\arguments{
\item{family}{Bivariate copula family, either its number or its character
expression (see table below).
\tabular{rll}{
No.        \tab Short name         \tab Long name \cr
\code{0}   \tab \code{"I"}         \tab \code{"Independence"} \cr
\code{1}   \tab \code{"N"}         \tab \code{"Gaussian"} \cr
\code{2}   \tab \code{"t"}         \tab \code{"t"} \cr
\code{3}   \tab \code{"C"}         \tab \code{"Clayton"} \cr
\code{4}   \tab \code{"G"}         \tab \code{"Gumbel"} \cr
\code{5}   \tab \code{"F"}         \tab \code{"Frank"} \cr
\code{6}   \tab \code{"J"}         \tab \code{"Joe"} \cr
\code{7}   \tab \code{"BB1"}       \tab \code{"BB1"} \cr
\code{8}   \tab \code{"BB6"}       \tab \code{"BB6"} \cr
\code{9}   \tab \code{"BB7"}       \tab \code{"BB7"} \cr
\code{10}  \tab \code{"BB8"}       \tab \code{"Frank-Joe"} \cr
\code{13}  \tab \code{"SC"}        \tab \code{"Survival Clayton"} \cr
\code{14}  \tab \code{"SG"}        \tab \code{"Survival Gumbel"} \cr
\code{16}  \tab \code{"SJ"}        \tab \code{"Survival Joe"} \cr
\code{17}  \tab \code{"SBB1"}      \tab \code{"Survival BB1"} \cr
\code{18}  \tab \code{"SBB6"}      \tab \code{"Survival BB6"} \cr
\code{19}  \tab \code{"SBB7"}      \tab \code{"Survival BB7"} \cr
\code{20}  \tab \code{"SBB8"}      \tab \code{"Survival BB8"} \cr
\code{23}  \tab \code{"C90"}       \tab \code{"Rotated Clayton 90 degrees"} \cr
\code{24}  \tab \code{"G90"}       \tab \code{"Rotated Gumbel 90 degrees"} \cr
\code{26}  \tab \code{"J90"}       \tab \code{"Rotated Joe 90 degrees"} \cr
\code{27}  \tab \code{"BB1_90"}    \tab \code{"Rotated BB1 90 degrees"} \cr
\code{28}  \tab \code{"BB6_90"}    \tab \code{"Rotated BB6 90 degrees"} \cr
\code{29}  \tab \code{"BB7_90"}    \tab \code{"Rotated BB7 90 degrees"} \cr
\code{30}  \tab \code{"BB8_90"}    \tab \code{"Rotated Frank-Joe 90 degrees"} \cr
\code{33}  \tab \code{"C270"}      \tab \code{"Rotated Clayton 270 degrees"} \cr
\code{34}  \tab \code{"G270"}      \tab \code{"Rotated Gumbel 270 degrees"} \cr
\code{36}  \tab \code{"J270"}      \tab \code{"Rotated Joe 270 degrees"} \cr
\code{37}  \tab \code{"BB1_270"}   \tab \code{"Rotated BB1 270 degrees"} \cr
\code{38}  \tab \code{"BB6_270"}   \tab \code{"Rotated BB6 270 degrees"} \cr
\code{39}  \tab \code{"BB7_270"}   \tab \code{"Rotated BB7 270 degrees"} \cr
\code{40}  \tab \code{"BB8_270"}   \tab \code{"Rotated Frank-Joe 270 degrees"} \cr
\code{104} \tab \code{"Tawn"}      \tab \code{"Tawn type 1"} \cr
\code{114} \tab \code{"Tawn180"}   \tab \code{"Rotated Tawn type 1 180 degrees"} \cr
\code{124} \tab \code{"Tawn90"}    \tab \code{"Rotated Tawn type 1 90 degrees"} \cr
\code{134} \tab \code{"Tawn270"}   \tab \code{"Rotated Tawn type 1 270 degrees"} \cr
\code{204} \tab \code{"Tawn2"}     \tab \code{"Tawn type 2"} \cr
\code{214} \tab \code{"Tawn2_180"} \tab \code{"Rotated Tawn type 2 180 degrees"} \cr
\code{224} \tab \code{"Tawn2_90"}  \tab \code{"Rotated Tawn type 2 90 degrees"} \cr
\code{234} \tab \code{"Tawn2_270"} \tab \code{"Rotated Tawn type 2 270 degrees"} \cr
}}

\item{short}{Logical; if the number of a bivariate copula family is used and
\code{short = TRUE} (default), a short version of the corresponding
character expression is returned, otherwise the long version.}
}
\value{
The transformed bivariate copula family (see table above).
}
\description{
This function transforms the bivariate copula family number into its
character expression and vice versa.
}
\examples{

## family number to character expression
family <- 1
BiCopName(family, short = TRUE)	 # short version
BiCopName(family, short = FALSE)	 # long version

## family character expression (short version) to number
family <- "C"
BiCopName(family)	# as number

## family character expression (long version) to number
family <- "Clayton"
BiCopName(family)	# as number

## vectors of families
BiCopName(1:10)    # as character expression
BiCopName(c("Clayton","t","J"))    # as number

}
\seealso{
\code{\link{RVineTreePlot}}
}
\author{
Ulf Schepsmeier
}
