% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H_pw.R
\name{H_pw}
\alias{H_pw}
\title{Computes cumulative hazard at duration t.}
\usage{
H_pw(t, breakpoints, rates)
}
\arguments{
\item{t}{Duration at which cumulative hazard is required.}

\item{breakpoints}{Breakpoints: values of x at which piecewise-constant
rates change.}

\item{rates}{Piecewise-constant rates}
}
\value{
Cumulative hazard at duration t
}
\description{
Computes cumulative hazard at duration t from age-specific demographic
rates.
}
\examples{

breakpoints <- c(0, 10, 20, 30, 60)
rates <- c(0.01,0.02,0.04,0.15)
z <- H_pw(t=0:40, breakpoints=breakpoints, rates=rates)


utils::data(rates)
ages <- as.numeric(rownames(rates$ASDR))
breakpoints <- c(ages,120)
zz <- H_pw(t=ages, breakpoints=breakpoints, rates=rates$ASDR[,1])


}
\seealso{
Function H_pw called by pw_root, which is called by r_pw_exp.
}
\author{
Frans Willekens
}
