% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_worldpop_data.R
\name{download_worldpop_data}
\alias{download_worldpop_data}
\title{Download WorldPop population raster data}
\usage{
download_worldpop_data(
  iso3,
  year,
  constrained = FALSE,
  UN_adjusted = FALSE,
  path_output
)
}
\arguments{
\item{iso3}{A three-letter capitalized character string. Must follow the ISO-3166 Alpha-3 country code
standard (\url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}). Can accept a vector of multiple ISO codes.}

\item{year}{A numeric or integer scalar giving the year of WorldPop data to download (as of 2024-05-15, years 2000-2020 are available)}

\item{constrained}{Logical indicating whether to get population counts estimated using constrained models (details \href{https://www.worldpop.org/methods/top_down_constrained_vs_unconstrained/}{HERE}).
Default is FALSE.}

\item{UN_adjusted}{Logical indicating whether to get population counts that are adjusted to match United Nations national population estimates
(details \href{https://hub.worldpop.org/project/categories?id=3}{HERE}). Default is FALSE.}

\item{path_output}{A character string giving the file path of an output directory to save downloaded data.}
}
\value{
Character string giving path to downloaded data.
}
\description{
This function takes a single ISO country code and downloads the appropriate population count raster data (100m grid cell resolution)
from the WorldPop FTP data server. Note that these data are spatial disaggregations of census data using random forest models described in
\href{https://www.tandfonline.com/doi/full/10.1080/20964471.2019.1625151}{Lloyd et al. 2019} and available for manual download at
\url{https://hub.worldpop.org/geodata/listing?id=29}. Downloaded data sets are
saved to the \code{path_output} directory in .tif format.
}
\examples{
\donttest{

download_worldpop_data(iso3 = 'MCO',
                       year = 2020,
                       constrained = TRUE,
                       UN_adjusted = FALSE,
                       path_output = tempdir())

}
}
