#' BDI Dataset
#'
#' The dataset contains measurements of attitudes and symptoms of depression using the
#' 13-item short form of the Beck Depression Inventory (BDI), collected from 2,200 Amazon Mechanical Turk
#' workers (Keller et al., 2022)
#'
#'
#' @name BDI_WSC
#' @docType data
#' @format BDI_WSC is a data frame with 2200 cases (rows) and 13 variables (columns).
#' The variables are named item_1, item_2, ... , item_13.
#'
#' @usage data(BDI_WSC)
#'
#' @references Beck, A. T., & Beck, R. W. (1972). Screening Depressed Patients in Family
#' Practice: A Rapid Technic. Postgraduate Medicine, 52(6), 81-85.
#' https://doi.org/10.1080/00325481.1972.11713319
#'
#' @keywords datasets
#'
#' @examples
#' BDI_WSC

NULL
